/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.accountaff;

import javax.annotation.Nonnull;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.plugin.accountaff.Info;
import org.jivesoftware.openfire.plugin.accountaff.InfoDAO;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class EmbedPresenceDirectedPacketInterceptor
implements PacketInterceptor {
    private static final Logger Log = LoggerFactory.getLogger(EmbedPresenceDirectedPacketInterceptor.class);
    public static final String NAMESPACE = "urn:xmpp:raa:0#embed-presence-directed";

    public void interceptPacket(Packet packet, Session session, boolean incoming, boolean processed) throws PacketRejectedException {
        if (processed) {
            return;
        }
        if (!incoming || !(session instanceof LocalClientSession)) {
            return;
        }
        if (!(packet instanceof Presence) || ((Presence)packet).getType() != null) {
            return;
        }
        boolean didRemoveSomething = packet.deleteExtension("info", "urn:xmpp:raa:0");
        if (didRemoveSomething) {
            Log.info("Prevented RAA spoofing: Removed RAA 'info' extension from presence stanza of type {} sent by {} addressed to: {}", new Object[]{((Presence)packet).getType(), packet.getFrom(), packet.getTo()});
        }
        JID originator = packet.getFrom();
        JID recipient = packet.getTo();
        if (originator == null) {
            Log.warn("Unable to process directed presence stanza, as the stanza has no 'from' attribute: {}", (Object)packet);
        } else if (recipient == null) {
            Log.trace("Not processing a regular presence update sent by '{}'.", (Object)originator);
        } else {
            boolean isSubscribedToRecipient = EmbedPresenceDirectedPacketInterceptor.isSubscribedToRecipient(originator.getNode(), recipient);
            if (isSubscribedToRecipient) {
                Log.trace("Skip adding info to directed presence stanza from user '{}' to user '{}' as the originator is subscribed to the presence of the recipient.", (Object)originator, (Object)recipient);
            } else {
                Log.trace("Attempting to add info to directed presence stanza from user '{}' to user '{}'", (Object)originator, (Object)recipient);
                Info info = InfoDAO.lookup(originator);
                if (info != null) {
                    packet.getElement().add(info.asElement());
                }
            }
        }
    }

    public static boolean isSubscribedToRecipient(@Nonnull String username, @Nonnull JID recipient) {
        try {
            Roster roster = XMPPServer.getInstance().getRosterManager().getRoster(username);
            RosterItem.SubType subType = roster.getRosterItem(recipient).getSubStatus();
            return subType == RosterItem.SUB_TO || subType == RosterItem.SUB_BOTH;
        }
        catch (UserNotFoundException e) {
            return false;
        }
    }
}

