/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.accountaff;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.plugin.accountaff.Affiliation;
import org.jivesoftware.util.XMPPDateTimeFormat;

public class Info {
    public static final String NAMESPACE = "urn:xmpp:raa:0";
    private final Affiliation affiliation;
    private final Instant since;
    private final Integer trust;

    public Info(@Nonnull Affiliation affiliation, @Nullable Instant since, @Nullable Integer trust) {
        this.affiliation = affiliation;
        Instant instant = this.since = since == null ? null : since.truncatedTo(ChronoUnit.DAYS);
        if (trust != null && (trust < 0 || trust > 100)) {
            throw new IllegalArgumentException("Argumenet 'trust' must be null, or a value between 0 and 100 (inclusive). It was: " + trust);
        }
        this.trust = trust;
    }

    public Element asElement() {
        Element result = DocumentHelper.createElement((QName)QName.get((String)"info", (String)NAMESPACE));
        result.addAttribute("affiliation", this.affiliation.toString().toLowerCase());
        if (this.since != null) {
            result.addAttribute("since", XMPPDateTimeFormat.format((Date)java.sql.Date.from(this.since)));
        }
        if (this.trust != null) {
            result.addAttribute("trust", String.valueOf(this.trust));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Info info = (Info)o;
        return this.affiliation == info.affiliation && Objects.equals(this.since, info.since) && Objects.equals(this.trust, info.trust);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.affiliation, this.since, this.trust});
    }

    public String toString() {
        return "Info{affiliation=" + (Object)((Object)this.affiliation) + ", since=" + this.since + ", trust=" + this.trust + '}';
    }
}

