/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.avatarresizer;

import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.dom4j.Element;
import org.jivesoftware.util.Base64;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resizer {
    private static final Logger Log = LoggerFactory.getLogger(Resizer.class);

    public static void resizeAvatar(Element vCardElement) {
        int targetDimension;
        if (vCardElement == null) {
            return;
        }
        if (vCardElement.element("PHOTO") == null) {
            return;
        }
        if (vCardElement.element("PHOTO").element("BINVAL") == null || vCardElement.element("PHOTO").element("TYPE") == null) {
            return;
        }
        Element element = vCardElement.element("PHOTO").element("BINVAL");
        if (element.getTextTrim() == null || element.getTextTrim().isEmpty()) {
            return;
        }
        String type = vCardElement.element("PHOTO").element("TYPE").getTextTrim();
        Iterator<ImageWriter> it = ImageIO.getImageWritersByMIMEType(type);
        if (!it.hasNext()) {
            Log.debug("Cannot resize avatar. No writers available for MIME type {}.", (Object)type);
            return;
        }
        ImageWriter iw = it.next();
        byte[] original = Base64.decode((String)element.getTextTrim());
        byte[] resized = Resizer.cropAndShrink(original, targetDimension = JiveGlobals.getIntProperty((String)"avatar.resize.targetdimension", (int)96), iw);
        if (resized != null) {
            Log.debug("Replacing original avatar in vcard with a resized variant.");
            vCardElement.element("PHOTO").element("BINVAL").setText(Base64.encodeBytes((byte[])resized));
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] cropAndShrink(byte[] bytes, int targetDimension, ImageWriter iw) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

