/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.blacklistspam;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.igniterealtime.openfire.plugin.blacklistspam.Blacklist;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class BlacklistFactory {
    private static final Logger Log = LoggerFactory.getLogger(BlacklistFactory.class);

    public static Blacklist fromURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 'url' cannot be null");
        }
        try {
            Log.debug("Obtaining blacklist from {}", (Object)url);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setConnectTimeout(JiveGlobals.getIntProperty((String)"blacklistspam.connection.connect.timeout", (int)60000));
            con.setReadTimeout(JiveGlobals.getIntProperty((String)"blacklistspam.connection.read.timeout", (int)60000));
            con.setRequestProperty("Content-Type", JiveGlobals.getProperty((String)"blacklistspam.connection.request.accept", (String)"text/plain"));
            con.setInstanceFollowRedirects(JiveGlobals.getBooleanProperty((String)"blacklistspam.connection.request.followredirects", (boolean)true));
            int responseCode = con.getResponseCode();
            String responseMessage = con.getResponseMessage();
            Log.trace("HTTP response for GET {} was {} {}", new Object[]{url, responseCode, responseMessage});
            if (responseCode == 204) {
                Log.debug("HTTP response code was 204: returning an empty blacklist.");
                return new Blacklist(Collections.emptyList());
            }
            if (responseCode >= 200 && responseCode <= 299) {
                Log.debug("Instantiating new blacklist from HTTP response body.");
                List<String> content = BlacklistFactory.responseAsList(con);
                Set<JID> jids = BlacklistFactory.asJIDs(content);
                Blacklist result = new Blacklist(jids);
                return result;
            }
            if (responseCode >= 400 && responseCode <= 499) {
                String response = BlacklistFactory.errorResponseAsText(con);
                Log.error("The request to obtain a blacklist from {} returned a {} {} response indicating a problem with the request: {}", new Object[]{url, responseCode, responseMessage, response});
                return null;
            }
            if (responseCode >= 500) {
                String response = BlacklistFactory.errorResponseAsText(con);
                Log.warn("The request to obtain a blacklist from {} returned a {} {} response indicating a problem with the remote server: {}", new Object[]{url, responseCode, responseMessage, response});
                return null;
            }
            String response = BlacklistFactory.errorResponseAsText(con);
            Log.warn("The request to obtain a blacklist from {} returned an unexpected {} {} response: {}", new Object[]{url, responseCode, responseMessage, response});
            return null;
        }
        catch (IOException e) {
            Log.warn("An exception occurred while obtaining a blacklist.", (Throwable)e);
            return null;
        }
    }

    private static List<String> responseAsList(HttpURLConnection con) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String line;
            ArrayList<String> content = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                content.add(line.trim());
            }
            ArrayList<String> arrayList = content;
            return arrayList;
        }
    }

    private static String errorResponseAsText(HttpURLConnection con) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getErrorStream()));){
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = in.readLine()) != null) {
                content.append(line);
            }
            String string = content.toString();
            return string;
        }
    }

    private static Set<JID> asJIDs(Collection<String> content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 'content' cannot be null.");
        }
        HashSet<JID> result = new HashSet<JID>();
        for (String line : content) {
            try {
                JID jid = new JID(line);
                result.add(jid);
            }
            catch (Exception e) {
                Log.debug("Unable to parse JID from {}. Skipping value.", (Object)line, (Object)e);
            }
        }
        return result;
    }
}

