/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.emailListener;

import com.sun.mail.imap.IMAPFolder;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.Log;
import org.jivesoftware.util.StringUtils;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class EmailListener {
    private static final String SSL_FACTORY = "org.jivesoftware.util.SimpleSSLSocketFactory";
    private static final EmailListener instance = new EmailListener();
    private MessageCountAdapter messageListener;
    private Folder folder;
    private boolean started = false;

    public static EmailListener getInstance() {
        return instance;
    }

    private EmailListener() {
    }

    public static boolean testConnection(String host, int port, boolean isSSLEnabled, String user, String password, String folderName) {
        Folder folder = EmailListener.openFolder(host, port, isSSLEnabled, user, password, folderName);
        boolean success = folder != null && folder.isOpen();
        EmailListener.closeFolder(folder, null);
        return success;
    }

    public void start() {
        if (this.started) {
            return;
        }
        Thread thread = new Thread("Email Listener Thread"){

            @Override
            public void run() {
                EmailListener.this.folder = EmailListener.openFolder(EmailListener.this.getHost(), EmailListener.this.getPort(), EmailListener.this.isSSLEnabled(), EmailListener.this.getUser(), EmailListener.this.getPassword(), EmailListener.this.getFolder());
                if (EmailListener.this.folder != null) {
                    EmailListener.this.listenMessages();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.started = true;
    }

    public void stop() {
        EmailListener.closeFolder(this.folder, this.messageListener);
        this.started = false;
        this.folder = null;
        this.messageListener = null;
    }

    private void listenMessages() {
        try {
            IMAPFolder f;
            this.messageListener = new MessageCountAdapter(){

                public void messagesAdded(MessageCountEvent ev) {
                    javax.mail.Message[] msgs;
                    for (javax.mail.Message msg : msgs = ev.getMessages()) {
                        try {
                            EmailListener.this.sendMessage(msg);
                        }
                        catch (Exception e) {
                            Log.error((String)"Error while sending new email message", (Throwable)e);
                        }
                    }
                }
            };
            this.folder.addMessageCountListener((MessageCountListener)this.messageListener);
            int freq = this.getFrequency();
            boolean supportsIdle = false;
            try {
                if (this.folder instanceof IMAPFolder) {
                    f = (IMAPFolder)this.folder;
                    f.idle();
                    supportsIdle = true;
                }
            }
            catch (FolderClosedException fex) {
                throw fex;
            }
            catch (MessagingException mex) {
                supportsIdle = false;
            }
            while (this.messageListener != null) {
                if (supportsIdle && this.folder instanceof IMAPFolder) {
                    f = (IMAPFolder)this.folder;
                    f.idle();
                    continue;
                }
                Thread.sleep(freq);
                if (this.folder == null || !this.folder.isOpen()) continue;
                this.folder.getMessageCount();
            }
        }
        catch (Exception ex) {
            Log.error((String)"Error listening new email messages", (Throwable)ex);
        }
    }

    private void sendMessage(javax.mail.Message message) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("New email has been received\n");
        sb.append("From: ");
        for (Address address : message.getFrom()) {
            sb.append(address.toString()).append(" ");
        }
        sb.append("\n");
        Date date = message.getSentDate();
        sb.append("Received: ").append(date != null ? date.toString() : "UNKNOWN").append("\n");
        sb.append("Subject: ").append(message.getSubject()).append("\n");
        this.appendMessagePart((Part)message, sb);
        for (String user : this.getUsers()) {
            Message notification = new Message();
            notification.setFrom(XMPPServer.getInstance().getServerInfo().getXMPPDomain());
            notification.setTo(user);
            notification.setSubject("New email has been received");
            notification.setBody(sb.toString());
            XMPPServer.getInstance().getMessageRouter().route(notification);
        }
    }

    private void appendMessagePart(Part part, StringBuilder sb) throws Exception {
        if (part.isMimeType("text/plain")) {
            sb.append((String)part.getContent()).append("\n");
        } else if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                this.appendMessagePart((Part)mp.getBodyPart(i), sb);
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.appendMessagePart((Part)part.getContent(), sb);
        }
    }

    private static Folder openFolder(String host, Integer port, Boolean isSSLEnabled, String user, String password, String folder) {
        if (host == null || port == null || isSSLEnabled == null || user == null || password == null || folder == null) {
            return null;
        }
        try {
            Properties props = System.getProperties();
            props.setProperty("mail.imap.host", host);
            props.setProperty("mail.imap.port", String.valueOf(port));
            props.setProperty("mail.imap.connectiontimeout", String.valueOf(10000));
            props.setProperty("mail.debug", JiveGlobals.getProperty((String)"plugin.email.listener.debug", (String)"false"));
            if (isSSLEnabled.booleanValue()) {
                Security.setProperty("ssl.SocketFactory.provider", SSL_FACTORY);
                props.setProperty("mail.imap.socketFactory.class", SSL_FACTORY);
                props.setProperty("mail.imap.socketFactory.fallback", "true");
            }
            Session session = Session.getInstance((Properties)props, null);
            Store store = session.getStore(isSSLEnabled != false ? "imaps" : "imap");
            store.connect(host, user, password);
            Folder newFolder = store.getFolder(folder);
            if (newFolder == null || !newFolder.exists()) {
                Log.error((String)("Invalid email folder: " + folder));
                return null;
            }
            newFolder.open(2);
            return newFolder;
        }
        catch (Exception e) {
            Log.error((String)"Error while initializing email listener", (Throwable)e);
            return null;
        }
    }

    private static void closeFolder(Folder folder, MessageCountAdapter messageListener) {
        if (folder != null) {
            if (messageListener != null) {
                folder.removeMessageCountListener((MessageCountListener)messageListener);
            }
            try {
                folder.close(false);
            }
            catch (MessagingException e) {
                Log.error((String)"Error closing folder", (Throwable)e);
            }
        }
    }

    public String getHost() {
        return JiveGlobals.getProperty((String)"plugin.email.listener.host");
    }

    public void setHost(String host) {
        JiveGlobals.setProperty((String)"plugin.email.listener.host", (String)host);
    }

    public int getPort() {
        return JiveGlobals.getIntProperty((String)"plugin.email.listener.port", (int)(this.isSSLEnabled() ? 993 : 143));
    }

    public void setPort(int port) {
        JiveGlobals.setProperty((String)"plugin.email.listener.port", (String)Integer.toString(port));
    }

    public String getUser() {
        return JiveGlobals.getProperty((String)"plugin.email.listener.user");
    }

    public void setUser(String user) {
        JiveGlobals.setProperty((String)"plugin.email.listener.user", (String)user);
    }

    public String getPassword() {
        return JiveGlobals.getProperty((String)"plugin.email.listener.password");
    }

    public void setPassword(String password) {
        JiveGlobals.setProperty((String)"plugin.email.listener.password", (String)password);
    }

    public String getFolder() {
        return JiveGlobals.getProperty((String)"plugin.email.listener.folder");
    }

    public void setFolder(String folder) {
        JiveGlobals.setProperty((String)"plugin.email.listener.folder", (String)folder);
    }

    public int getFrequency() {
        return JiveGlobals.getIntProperty((String)"plugin.email.listener.frequency", (int)300000);
    }

    public void setFrequency(int frequency) {
        JiveGlobals.setProperty((String)"plugin.email.listener.frequency", (String)Integer.toString(frequency));
    }

    public boolean isSSLEnabled() {
        return JiveGlobals.getBooleanProperty((String)"plugin.email.listener.ssl", (boolean)false);
    }

    public void setSSLEnabled(boolean enabled) {
        JiveGlobals.setProperty((String)"plugin.email.listener.ssl", (String)Boolean.toString(enabled));
    }

    public Collection<String> getUsers() {
        String users = JiveGlobals.getProperty((String)"plugin.email.listener.users");
        if (users == null || users.trim().length() == 0) {
            ArrayList<String> admins = new ArrayList<String>();
            for (JID jid : XMPPServer.getInstance().getAdmins()) {
                admins.add(jid.toString());
            }
            return admins;
        }
        return StringUtils.stringToCollection((String)users);
    }

    public void setUsers(Collection<String> users) {
        JiveGlobals.setProperty((String)"plugin.email.listener.users", (String)StringUtils.collectionToString(users));
    }
}

