/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugins.externalservicediscovery;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;
import org.igniterealtime.openfire.plugins.externalservicediscovery.Credentials;
import org.igniterealtime.openfire.plugins.externalservicediscovery.Service;
import org.igniterealtime.openfire.plugins.externalservicediscovery.ServiceManager;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;

public abstract class ExternalServiceDiscoveryIQHandler
extends IQHandler
implements ServerFeaturesProvider {
    private static final Logger Log = LoggerFactory.getLogger(ExternalServiceDiscoveryIQHandler.class);

    public ExternalServiceDiscoveryIQHandler() {
        super("XEP-0215: External Service Discovery");
    }

    public Iterator<String> getFeatures() {
        return Collections.singleton(this.getInfo().getNamespace()).iterator();
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        IQ response;
        if (packet.isResponse()) {
            Log.debug("Silently ignoring IQ response: {}", (Object)packet);
            return null;
        }
        if (IQ.Type.set == packet.getType()) {
            Log.info("Responding with an error to an IQ request of type 'set': {}", (Object)packet);
            IQ response2 = IQ.createResultIQ((IQ)packet);
            response2.setError(PacketError.Condition.service_unavailable);
            return response2;
        }
        switch (packet.getChildElement().getName()) {
            case "services": {
                response = this.handleServices(packet);
                break;
            }
            case "credentials": {
                response = this.handleCredentials(packet);
                break;
            }
            default: {
                Log.info("Responding with an error to an IQ request for which the element name escaped by namespace is not understood: {}", (Object)packet);
                response = IQ.createResultIQ((IQ)packet);
                response.setError(PacketError.Condition.service_unavailable);
            }
        }
        Log.info("Responding with {} to request {}", (Object)response.toXML(), (Object)packet.toXML());
        return response;
    }

    protected IQ handleServices(IQ request) {
        Map<Service, Credentials> services;
        ServiceManager serviceManager = ServiceManager.getInstance();
        String requestedType = request.getChildElement().attributeValue("type");
        if (requestedType == null || requestedType.isEmpty()) {
            Log.debug("Handling request for all services.");
            services = serviceManager.getServicesFor(request.getFrom());
        } else {
            Log.debug("Handling request for services of a specific type: {}.", (Object)requestedType);
            services = serviceManager.getServicesFor(request.getFrom(), requestedType);
        }
        IQ response = IQ.createResultIQ((IQ)request);
        Element childElement = response.setChildElement(request.getChildElement().getName(), request.getChildElement().getNamespaceURI());
        if (requestedType != null && !requestedType.isEmpty()) {
            childElement.addAttribute("type", requestedType);
        }
        for (Map.Entry<Service, Credentials> entry : services.entrySet()) {
            this.addServiceXml(childElement, entry.getKey(), null, entry.getValue());
        }
        return response;
    }

    protected IQ handleCredentials(IQ request) {
        Map<Service, Credentials> services;
        Integer requestedPort;
        Element requestedService = request.getChildElement().element("service");
        if (requestedService == null) {
            Log.debug("Responding with an error to a request for credentials that did not specify any service: {}", (Object)request);
            IQ response = IQ.createResultIQ((IQ)request);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        String requestedHost = requestedService.attributeValue("host");
        String requestedType = requestedService.attributeValue("type");
        if (requestedService.attribute("port") != null) {
            try {
                requestedPort = Integer.parseInt(requestedService.attributeValue("port"));
            }
            catch (NumberFormatException ex) {
                Log.debug("Responding with an error to a request for credentials that specified a malformed port number for a service: {}", (Object)request, (Object)ex);
                IQ response = IQ.createResultIQ((IQ)request);
                response.setError(PacketError.Condition.bad_request);
                return response;
            }
        } else {
            requestedPort = null;
        }
        if (requestedHost == null || requestedHost.isEmpty() || requestedType == null || requestedType.isEmpty()) {
            Log.debug("Responding with an error to a request for credentials that did not specify any service: {}", (Object)request);
            IQ response = IQ.createResultIQ((IQ)request);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        ServiceManager serviceManager = ServiceManager.getInstance();
        if (requestedPort == null) {
            Log.debug("Handling request for credentials by {} for the {} service: {}", new Object[]{request.getFrom(), requestedType, requestedHost});
            services = serviceManager.getServicesFor(request.getFrom(), requestedHost, requestedType);
        } else {
            Log.debug("Handling request for credentials by {} for the {} service: {}:{}", new Object[]{request.getFrom(), requestedType, requestedHost, requestedPort});
            services = serviceManager.getServicesFor(request.getFrom(), requestedHost, requestedType, requestedPort);
        }
        IQ response = IQ.createResultIQ((IQ)request);
        Element childElement = response.setChildElement("credentials", request.getChildElement().getNamespaceURI());
        for (Map.Entry<Service, Credentials> service : services.entrySet()) {
            this.addServiceXml(childElement, service.getKey(), null, service.getValue());
        }
        return response;
    }

    abstract void addServiceXml(Element var1, Service var2, Service.Action var3, Credentials var4);
}

