/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugins.externalservicediscovery;

import java.util.Date;
import org.dom4j.Element;
import org.igniterealtime.openfire.plugins.externalservicediscovery.Credentials;
import org.igniterealtime.openfire.plugins.externalservicediscovery.ExternalServiceDiscoveryIQHandler;
import org.igniterealtime.openfire.plugins.externalservicediscovery.Service;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalServiceDiscoveryIQHandlerV2
extends ExternalServiceDiscoveryIQHandler {
    private static final Logger Log = LoggerFactory.getLogger(ExternalServiceDiscoveryIQHandlerV2.class);
    private static final IQHandlerInfo INFO = new IQHandlerInfo("services", "urn:xmpp:extdisco:2");

    public IQHandlerInfo getInfo() {
        return INFO;
    }

    @Override
    public void addServiceXml(Element parent, Service service, Service.Action action, Credentials credentials) {
        Element result = parent.addElement("service");
        if (action != null) {
            result.addAttribute("action", action.toString());
        }
        if (credentials != null) {
            if (credentials.getExpires() != null) {
                result.addAttribute("expires", XMPPDateTimeFormat.format((Date)credentials.getExpires()));
            }
            if (credentials.getUsername() != null) {
                result.addAttribute("username", credentials.getUsername());
            }
            if (credentials.getPassword() != null) {
                result.addAttribute("password", credentials.getPassword());
            }
        }
        if (service.getHost() != null) {
            result.addAttribute("host", service.getHost());
        }
        if (service.getName() != null) {
            result.addAttribute("name", service.getName());
        }
        if (service.getPort() != null) {
            result.addAttribute("port", Integer.toString(service.getPort()));
        }
        if (service.getRestricted() != null) {
            result.addAttribute("restricted", Boolean.toString(service.getRestricted()));
        }
        if (service.getTransport() != null) {
            result.addAttribute("transport", service.getTransport());
        }
        if (service.getType() != null) {
            result.addAttribute("type", service.getType());
        }
    }
}

