/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugins.externalservicediscovery;

import java.io.File;
import java.util.Iterator;
import org.igniterealtime.openfire.plugins.externalservicediscovery.ExternalServiceDiscoveryIQHandlerV1;
import org.igniterealtime.openfire.plugins.externalservicediscovery.ExternalServiceDiscoveryIQHandlerV2;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.handler.IQHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalServiceDiscoveryPlugin
implements Plugin {
    private static final Logger Log = LoggerFactory.getLogger(ExternalServiceDiscoveryPlugin.class);
    private ExternalServiceDiscoveryIQHandlerV1 iqHandlerV1;
    private ExternalServiceDiscoveryIQHandlerV2 iqHandlerV2;

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        Log.debug("Registering IQ Handlers...");
        this.iqHandlerV1 = new ExternalServiceDiscoveryIQHandlerV1();
        this.iqHandlerV2 = new ExternalServiceDiscoveryIQHandlerV2();
        XMPPServer.getInstance().getIQRouter().addHandler((IQHandler)this.iqHandlerV1);
        XMPPServer.getInstance().getIQRouter().addHandler((IQHandler)this.iqHandlerV2);
        Log.debug("Registering Server Features...");
        Iterator<String> it = this.iqHandlerV1.getFeatures();
        while (it.hasNext()) {
            XMPPServer.getInstance().getIQDiscoInfoHandler().addServerFeature(it.next());
        }
        it = this.iqHandlerV2.getFeatures();
        while (it.hasNext()) {
            XMPPServer.getInstance().getIQDiscoInfoHandler().addServerFeature(it.next());
        }
        Log.debug("Initialized.");
    }

    public void destroyPlugin() {
        Log.debug("Removing Server Features...");
        Iterator<String> it = this.iqHandlerV2.getFeatures();
        while (it.hasNext()) {
            XMPPServer.getInstance().getIQDiscoInfoHandler().removeServerFeature(it.next());
        }
        it = this.iqHandlerV1.getFeatures();
        while (it.hasNext()) {
            XMPPServer.getInstance().getIQDiscoInfoHandler().removeServerFeature(it.next());
        }
        if (this.iqHandlerV2 != null) {
            Log.debug("Removing IQ Handler...");
            XMPPServer.getInstance().getIQRouter().removeHandler((IQHandler)this.iqHandlerV2);
        }
        if (this.iqHandlerV1 != null) {
            Log.debug("Removing IQ Handler...");
            XMPPServer.getInstance().getIQRouter().removeHandler((IQHandler)this.iqHandlerV1);
        }
        Log.debug("Destroyed.");
    }
}

