/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugins.externalservicediscovery;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.igniterealtime.openfire.plugins.externalservicediscovery.Credentials;
import org.jivesoftware.database.JiveID;
import org.jivesoftware.database.SequenceManager;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

@JiveID(value=937)
public final class Service {
    private static final Logger Log = LoggerFactory.getLogger(Service.class);
    private final long databaseId;
    private final String host;
    private final String name;
    private final Integer port;
    private final Boolean restricted;
    private final String transport;
    private final String type;
    private final Credentials credentials;
    private final SecretKeySpec secretKey;

    public Service(String name, String host, Integer port, String transport, String type) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Argument 'host' cannot be null or an empty string.");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Argument 'type' cannot be null or an empty string.");
        }
        this.databaseId = SequenceManager.nextID((Object)this);
        this.host = host;
        this.name = name;
        this.port = port;
        this.restricted = false;
        this.transport = transport;
        this.type = type;
        this.credentials = null;
        this.secretKey = null;
    }

    public Service(String name, String host, Integer port, String transport, String type, String username, String password) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Argument 'host' cannot be null or an empty string.");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Argument 'type' cannot be null or an empty string.");
        }
        this.databaseId = SequenceManager.nextID((Object)this);
        this.host = host;
        this.name = name;
        this.port = port;
        this.restricted = true;
        this.transport = transport;
        this.type = type;
        this.credentials = new Credentials(username, password, null);
        this.secretKey = null;
    }

    public Service(String name, String host, Integer port, String transport, String type, String sharedSecret) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Argument 'host' cannot be null or an empty string.");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Argument 'type' cannot be null or an empty string.");
        }
        this.databaseId = SequenceManager.nextID((Object)this);
        this.host = host;
        this.name = name;
        this.port = port;
        this.restricted = true;
        this.transport = transport;
        this.type = type;
        this.credentials = null;
        this.secretKey = sharedSecret == null || sharedSecret.isEmpty() ? null : new SecretKeySpec(sharedSecret.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
    }

    Service(long databaseId, String name, String host, Integer port, Boolean restricted, String transport, String type, String username, String password, String sharedSecret) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Argument 'host' cannot be null or an empty string.");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Argument 'type' cannot be null or an empty string.");
        }
        this.databaseId = databaseId;
        this.host = host;
        this.name = name;
        this.port = port;
        this.restricted = restricted;
        this.transport = transport;
        this.type = type;
        this.credentials = username == null && password == null ? null : new Credentials(username, password, null);
        this.secretKey = sharedSecret == null ? null : new SecretKeySpec(sharedSecret.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
    }

    public long getDatabaseId() {
        return this.databaseId;
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPort() {
        return this.port;
    }

    public Boolean getRestricted() {
        return this.restricted;
    }

    public String getTransport() {
        return this.transport;
    }

    public String getType() {
        return this.type;
    }

    public String getSharedSecret() {
        if (this.secretKey == null) {
            return null;
        }
        return new String(this.secretKey.getEncoded(), StandardCharsets.UTF_8);
    }

    public String getRawUsername() {
        if (this.credentials == null) {
            return null;
        }
        return this.credentials.getUsername();
    }

    String getRawPassword() {
        if (this.credentials == null) {
            return null;
        }
        return this.credentials.getPassword();
    }

    public Credentials getCredentialsFor(JID user) {
        if (this.credentials != null) {
            return this.credentials;
        }
        if (this.secretKey != null) {
            String password;
            String asSecondsSinceEpoch;
            int ttl = 86400;
            Date expires = new Date(System.currentTimeMillis() + 86400000L);
            String username = asSecondsSinceEpoch = Long.toString(expires.getTime() / 1000L);
            if (user != null) {
                try {
                    username = asSecondsSinceEpoch + ":" + URLEncoder.encode(user.toBareJID(), "ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    Log.debug("Unable to encode JID ''.", (Object)user.toBareJID(), (Object)e);
                }
            }
            try {
                Mac mac = Mac.getInstance("HmacSHA1");
                mac.init(this.secretKey);
                byte[] nonce = mac.doFinal(username.getBytes(StandardCharsets.UTF_8));
                password = StringUtils.encodeBase64((byte[])nonce);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                Log.warn("Unable to create ephemeral credentials for '{}' on {}:{}", (Object)new Object[]{user, this.host, this.port}, (Object)e);
                return null;
            }
            return new Credentials(username, password, expires);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        if (this.databaseId != service.databaseId) {
            return false;
        }
        if (!this.host.equals(service.host)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(service.name) : service.name != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(service.port) : service.port != null) {
            return false;
        }
        if (this.restricted != null ? !this.restricted.equals(service.restricted) : service.restricted != null) {
            return false;
        }
        if (this.transport != null ? !this.transport.equals(service.transport) : service.transport != null) {
            return false;
        }
        if (!this.type.equals(service.type)) {
            return false;
        }
        if (this.credentials != null ? !this.credentials.equals(service.credentials) : service.credentials != null) {
            return false;
        }
        return this.secretKey != null ? this.secretKey.equals(service.secretKey) : service.secretKey == null;
    }

    public int hashCode() {
        int result = (int)(this.databaseId ^ this.databaseId >>> 32);
        result = 31 * result + this.host.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.restricted != null ? this.restricted.hashCode() : 0);
        result = 31 * result + (this.transport != null ? this.transport.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
        result = 31 * result + (this.secretKey != null ? this.secretKey.hashCode() : 0);
        return result;
    }

    static enum Action {
        add,
        remove,
        modify;

    }
}

