/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugins.externalservicediscovery;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.igniterealtime.openfire.plugins.externalservicediscovery.Credentials;
import org.igniterealtime.openfire.plugins.externalservicediscovery.Service;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class ServiceManager {
    private static final Logger Log = LoggerFactory.getLogger(ServiceManager.class);
    private Set<Service> services = new HashSet<Service>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceManager getInstance() {
        ServiceManager instance = new ServiceManager();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("SELECT * FROM ofExternalServices ");
            resultSet = pstmt.executeQuery();
            while (resultSet.next()) {
                long databaseId = resultSet.getLong("serviceID");
                String name = resultSet.getString("name");
                if (resultSet.wasNull() || name == null || name.isEmpty()) {
                    name = null;
                }
                String host = resultSet.getString("host");
                if (resultSet.wasNull() || host == null || host.isEmpty()) {
                    host = null;
                }
                Integer port = resultSet.getInt("port");
                if (resultSet.wasNull()) {
                    port = null;
                }
                Boolean restricted = resultSet.getBoolean("restricted");
                if (resultSet.wasNull()) {
                    restricted = null;
                }
                String transport = resultSet.getString("transport");
                if (resultSet.wasNull() || transport == null || transport.isEmpty()) {
                    transport = null;
                }
                String type = resultSet.getString("type");
                if (resultSet.wasNull() || type == null || type.isEmpty()) {
                    type = null;
                }
                String username = resultSet.getString("username");
                if (resultSet.wasNull() || username == null || username.isEmpty()) {
                    username = null;
                }
                String password = resultSet.getString("password");
                if (resultSet.wasNull() || password == null || password.isEmpty()) {
                    password = null;
                }
                String sharedSecret = resultSet.getString("sharedSecret");
                if (resultSet.wasNull() || sharedSecret == null || sharedSecret.isEmpty()) {
                    sharedSecret = null;
                }
                Service service = new Service(databaseId, name, host, port, restricted, transport, type, username, password, sharedSecret);
                instance.services.add(service);
                Log.debug("Loaded {} service at {} from database.", (Object)service.getType(), (Object)service.getHost());
            }
        }
        catch (Exception e) {
            try {
                Log.error("Unable to load services from database!", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(resultSet, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)resultSet, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)resultSet, (Statement)pstmt, (Connection)con);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(Service service) {
        if (this.services.add(service)) {
            Connection con = null;
            PreparedStatement pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("INSERT INTO ofExternalServices VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                pstmt.setLong(1, service.getDatabaseId());
                if (service.getName() == null || service.getName().isEmpty()) {
                    pstmt.setNull(2, 12);
                } else {
                    pstmt.setString(2, service.getName());
                }
                if (service.getHost() == null || service.getHost().isEmpty()) {
                    pstmt.setNull(3, 12);
                } else {
                    pstmt.setString(3, service.getHost());
                }
                if (service.getPort() == null) {
                    pstmt.setNull(4, 4);
                } else {
                    pstmt.setInt(4, service.getPort());
                }
                if (service.getRestricted() == null) {
                    pstmt.setNull(5, 16);
                } else {
                    pstmt.setBoolean(5, service.getRestricted());
                }
                if (service.getTransport() == null || service.getTransport().isEmpty()) {
                    pstmt.setNull(6, 1);
                } else {
                    pstmt.setString(6, service.getTransport());
                }
                if (service.getType() == null || service.getType().isEmpty()) {
                    pstmt.setNull(7, 1);
                } else {
                    pstmt.setString(7, service.getType());
                }
                if (service.getRawUsername() == null || service.getRawUsername().isEmpty()) {
                    pstmt.setNull(8, 12);
                } else {
                    pstmt.setString(8, service.getRawUsername());
                }
                if (service.getRawPassword() == null || service.getRawPassword().isEmpty()) {
                    pstmt.setNull(9, 12);
                } else {
                    pstmt.setString(9, service.getRawPassword());
                }
                if (service.getSharedSecret() == null || service.getSharedSecret().isEmpty()) {
                    pstmt.setNull(10, 12);
                } else {
                    pstmt.setString(10, service.getSharedSecret());
                }
                pstmt.executeUpdate();
                Log.info("Added {} service at {}.", (Object)service.getType(), (Object)service.getHost());
            }
            catch (Exception e) {
                try {
                    Log.error("Unable to persists service ({} at {}) in database!", (Object)new Object[]{service.getType(), service.getHost()}, (Object)e);
                    this.services.remove(service);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(Service service) {
        PreparedStatement pstmt;
        Connection con;
        block5: {
            con = null;
            pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("DELETE FROM ofExternalServices WHERE serviceID=?");
                pstmt.setLong(1, service.getDatabaseId());
                if (pstmt.executeUpdate() == 0) {
                    Log.warn("The query to remove {} service at {} from the database did not remove anything.", (Object)service.getType(), (Object)service.getHost());
                    break block5;
                }
                this.services.remove(service);
                Log.info("Removed {} service at {}.", (Object)service.getType(), (Object)service.getHost());
            }
            catch (Exception e) {
                try {
                    Log.error("Unable to remove service ({} at {}) from database!", (Object)new Object[]{service.getType(), service.getHost()}, (Object)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    public Set<Service> getAllServices() {
        return new HashSet<Service>(this.services);
    }

    public Map<Service, Credentials> getServicesFor(JID requester) {
        Log.debug("Obtaining credentials for {}", (Object)requester);
        HashMap<Service, Credentials> result = new HashMap<Service, Credentials>();
        for (Service service : this.services) {
            try {
                Credentials credentials = service.getCredentialsFor(requester);
                result.put(service, credentials);
            }
            catch (Exception e) {
                Log.warn("Unable to obtain credentials for requester '{}', for the {} service at: {}", (Object)new Object[]{requester, service.getType(), service.getHost()}, (Object)e);
            }
        }
        return result;
    }

    public Map<Service, Credentials> getServicesFor(JID requester, String requestedType) {
        Log.debug("Obtaining credentials for {} of type {}", (Object)requester, (Object)requestedType);
        HashMap<Service, Credentials> result = new HashMap<Service, Credentials>();
        for (Service service : this.services) {
            if (!requestedType.equals(service.getType())) continue;
            try {
                Credentials credentials = service.getCredentialsFor(requester);
                result.put(service, credentials);
            }
            catch (Exception e) {
                Log.warn("Unable to obtain credentials for requester '{}', for the {} service at: {}", (Object)new Object[]{requester, service.getType(), service.getHost()}, (Object)e);
            }
        }
        return result;
    }

    public Map<Service, Credentials> getServicesFor(JID requester, String requestedHost, String requestedType) {
        Log.debug("Obtaining credentials for {} on {} of type {}", new Object[]{requester, requestedHost, requestedType});
        HashMap<Service, Credentials> result = new HashMap<Service, Credentials>();
        for (Service service : this.services) {
            if (!requestedType.equals(service.getType()) || !requestedHost.equals(service.getHost())) continue;
            try {
                Credentials credentials = service.getCredentialsFor(requester);
                result.put(service, credentials);
            }
            catch (Exception e) {
                Log.warn("Unable to obtain credentials for requester '{}', for the {} service at: {}", (Object)new Object[]{requester, service.getType(), service.getHost()}, (Object)e);
            }
        }
        return result;
    }

    public Map<Service, Credentials> getServicesFor(JID requester, String requestedHost, String requestedType, int requestedPort) {
        Log.debug("Obtaining credentials for {} on {}:{} of type {}", new Object[]{requester, requestedHost, requestedPort, requestedType});
        HashMap<Service, Credentials> result = new HashMap<Service, Credentials>();
        for (Service service : this.services) {
            if (!requestedType.equals(service.getType()) || !requestedHost.equals(service.getHost()) || requestedPort != service.getPort()) continue;
            try {
                Credentials credentials = service.getCredentialsFor(requester);
                result.put(service, credentials);
            }
            catch (Exception e) {
                Log.warn("Unable to obtain credentials for requester '{}', for the {} service at: {}:{}", (Object)new Object[]{requester, requestedType, requestedHost, requestedPort}, (Object)e);
            }
        }
        return result;
    }
}

