/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.entity.MUCRoomEntities;
import org.jivesoftware.openfire.entity.MUCRoomEntity;
import org.jivesoftware.openfire.entity.ParticipantEntities;
import org.jivesoftware.openfire.entity.ParticipantEntity;
import org.jivesoftware.openfire.exception.MUCServiceException;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.utils.MUCRoomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class MUCRoomController {
    private static final Logger LOG = LoggerFactory.getLogger(MUCRoomController.class);
    public static final MUCRoomController INSTANCE = new MUCRoomController();

    public static MUCRoomController getInstance() {
        return INSTANCE;
    }

    public MUCRoomEntities getChatRooms(String serviceName, String channelType, String roomSearch) {
        List rooms = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRooms();
        ArrayList<MUCRoomEntity> mucRoomEntities = new ArrayList<MUCRoomEntity>();
        for (MUCRoom chatRoom : rooms) {
            if (roomSearch != null && !chatRoom.getName().contains(roomSearch)) continue;
            if (channelType.equals("all")) {
                mucRoomEntities.add(this.convertToMUCRoomEntity(chatRoom));
                continue;
            }
            if (!channelType.equals("public") || !chatRoom.isPublicRoom()) continue;
            mucRoomEntities.add(this.convertToMUCRoomEntity(chatRoom));
        }
        return new MUCRoomEntities(mucRoomEntities);
    }

    public MUCRoomEntity getChatRoom(String roomName, String serviceName) throws MUCServiceException {
        MUCRoom chatRoom = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName);
        if (chatRoom == null) {
            throw new MUCServiceException("Could not fetch the channel", roomName, "Chat room could be not found");
        }
        MUCRoomEntity mucRoomEntity = this.convertToMUCRoomEntity(chatRoom);
        return mucRoomEntity;
    }

    public void deleteChatRoom(String roomName, String serviceName) throws MUCServiceException {
        MUCRoom chatRoom = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        if (chatRoom == null) {
            throw new MUCServiceException("Could not remove the channel", roomName, "Chat room could be not found");
        }
        chatRoom.destroyRoom(null, null);
    }

    public void createChatRoom(String serviceName, MUCRoomEntity mucRoomEntity) throws MUCServiceException {
        try {
            this.createRoom(mucRoomEntity, serviceName);
        }
        catch (NotAllowedException e) {
            throw new MUCServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "NotAllowedException");
        }
        catch (ForbiddenException e) {
            throw new MUCServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "ForbiddenException");
        }
        catch (ConflictException e) {
            throw new MUCServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "ConflictException");
        }
    }

    public void updateChatRoom(String roomName, String serviceName, MUCRoomEntity mucRoomEntity) throws MUCServiceException {
        try {
            if (!roomName.equals(mucRoomEntity.getRoomName())) {
                throw new MUCServiceException("Could not update the channel. The room name is different to the entity room name.", roomName, "IllegalArgumentException");
            }
            this.createRoom(mucRoomEntity, serviceName);
        }
        catch (NotAllowedException e) {
            throw new MUCServiceException("Could not update the channel", roomName, "NotAllowedException");
        }
        catch (ForbiddenException e) {
            throw new MUCServiceException("Could not update the channel", roomName, "ForbiddenException");
        }
        catch (ConflictException e) {
            throw new MUCServiceException("Could not update the channel", roomName, "ConflictException");
        }
    }

    private void createRoom(MUCRoomEntity mucRoomEntity, String serviceName) throws NotAllowedException, ForbiddenException, ConflictException {
        JID owner = XMPPServer.getInstance().createJID("admin", null);
        if (mucRoomEntity.getOwners() != null && mucRoomEntity.getOwners().size() > 0) {
            owner = new JID(mucRoomEntity.getOwners().get(0));
        } else {
            ArrayList<String> owners = new ArrayList<String>();
            owners.add(owner.toBareJID());
            mucRoomEntity.setOwners(owners);
        }
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(mucRoomEntity.getRoomName().toLowerCase(), owner);
        room.setNaturalLanguageName(mucRoomEntity.getNaturalName());
        room.setSubject(mucRoomEntity.getSubject());
        room.setDescription(mucRoomEntity.getDescription());
        room.setPassword(mucRoomEntity.getPassword());
        room.setPersistent(mucRoomEntity.isPersistent());
        room.setPublicRoom(mucRoomEntity.isPublicRoom());
        room.setRegistrationEnabled(mucRoomEntity.isRegistrationEnabled());
        room.setCanAnyoneDiscoverJID(mucRoomEntity.isCanAnyoneDiscoverJID());
        room.setCanOccupantsChangeSubject(mucRoomEntity.isCanOccupantsChangeSubject());
        room.setCanOccupantsInvite(mucRoomEntity.isCanOccupantsInvite());
        room.setChangeNickname(mucRoomEntity.isCanChangeNickname());
        room.setModificationDate(mucRoomEntity.getModificationDate());
        room.setLogEnabled(mucRoomEntity.isLogEnabled());
        room.setLoginRestrictedToNickname(mucRoomEntity.isLoginRestrictedToNickname());
        room.setMaxUsers(mucRoomEntity.getMaxUsers());
        room.setMembersOnly(mucRoomEntity.isMembersOnly());
        room.setModerated(mucRoomEntity.isModerated());
        if (mucRoomEntity.getBroadcastPresenceRoles() != null) {
            room.setRolesToBroadcastPresence(mucRoomEntity.getBroadcastPresenceRoles());
        } else {
            room.setRolesToBroadcastPresence(new ArrayList());
        }
        this.setRoles(room, mucRoomEntity);
        if (mucRoomEntity.getCreationDate() != null) {
            room.setCreationDate(mucRoomEntity.getCreationDate());
        } else {
            room.setCreationDate(new Date());
        }
        if (mucRoomEntity.getModificationDate() != null) {
            room.setModificationDate(mucRoomEntity.getModificationDate());
        } else {
            room.setModificationDate(new Date());
        }
        room.unlock(room.getRole());
        if (room.isPersistent()) {
            room.saveToDB();
        }
    }

    public ParticipantEntities getRoomParticipants(String roomName, String serviceName) {
        ParticipantEntities participantEntities = new ParticipantEntities();
        ArrayList<ParticipantEntity> participants = new ArrayList<ParticipantEntity>();
        Collection serverParticipants = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName).getParticipants();
        for (MUCRole role : serverParticipants) {
            ParticipantEntity participantEntity = new ParticipantEntity();
            participantEntity.setJid(role.getRoleAddress().toFullJID());
            participantEntity.setRole(role.getRole().name());
            participantEntity.setAffiliation(role.getAffiliation().name());
            participants.add(participantEntity);
        }
        participantEntities.setParticipants(participants);
        return participantEntities;
    }

    public MUCRoomEntity convertToMUCRoomEntity(MUCRoom room) {
        MUCRoomEntity mucRoomEntity = new MUCRoomEntity(room.getNaturalLanguageName(), room.getName(), room.getDescription());
        mucRoomEntity.setCanAnyoneDiscoverJID(room.canAnyoneDiscoverJID());
        mucRoomEntity.setCanChangeNickname(room.canChangeNickname());
        mucRoomEntity.setCanOccupantsChangeSubject(room.canOccupantsChangeSubject());
        mucRoomEntity.setCanOccupantsInvite(room.canOccupantsInvite());
        mucRoomEntity.setPublicRoom(room.isPublicRoom());
        mucRoomEntity.setPassword(room.getPassword());
        mucRoomEntity.setPersistent(room.isPersistent());
        mucRoomEntity.setRegistrationEnabled(room.isRegistrationEnabled());
        mucRoomEntity.setLogEnabled(room.isLogEnabled());
        mucRoomEntity.setLoginRestrictedToNickname(room.isLoginRestrictedToNickname());
        mucRoomEntity.setMaxUsers(room.getMaxUsers());
        mucRoomEntity.setMembersOnly(room.isMembersOnly());
        mucRoomEntity.setModerated(room.isModerated());
        mucRoomEntity.setOwners(MUCRoomUtils.convertJIDsToStringList(room.getOwners()));
        mucRoomEntity.setAdmins(MUCRoomUtils.convertJIDsToStringList(room.getAdmins()));
        mucRoomEntity.setMembers(MUCRoomUtils.convertJIDsToStringList(room.getMembers()));
        mucRoomEntity.setOutcasts(MUCRoomUtils.convertJIDsToStringList(room.getOutcasts()));
        mucRoomEntity.setBroadcastPresenceRoles(room.getRolesToBroadcastPresence());
        mucRoomEntity.setCreationDate(room.getCreationDate());
        mucRoomEntity.setModificationDate(room.getModificationDate());
        return mucRoomEntity;
    }

    private void setRoles(MUCRoom room, MUCRoomEntity mucRoomEntity) throws ForbiddenException, NotAllowedException, ConflictException {
        ArrayList roles = new ArrayList();
        ArrayList owners = new ArrayList();
        ArrayList<JID> existingOwners = new ArrayList<JID>();
        List<JID> mucRoomEntityOwners = MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOwners());
        owners.addAll(room.getOwners());
        for (JID jid : owners) {
            if (!mucRoomEntityOwners.contains(jid)) continue;
            existingOwners.add(jid);
        }
        owners.removeAll(existingOwners);
        room.addOwners(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOwners()), room.getRole());
        roles.addAll(owners);
        roles.addAll(room.getAdmins());
        roles.addAll(room.getMembers());
        roles.addAll(room.getOutcasts());
        for (JID jid : roles) {
            room.addNone(jid, room.getRole());
        }
        room.addOwners(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOwners()), room.getRole());
        if (mucRoomEntity.getAdmins() != null) {
            room.addAdmins(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getAdmins()), room.getRole());
        }
        if (mucRoomEntity.getMembers() != null) {
            for (String memberJid : mucRoomEntity.getMembers()) {
                room.addMember(new JID(memberJid), null, room.getRole());
            }
        }
        if (mucRoomEntity.getOutcasts() != null) {
            for (String outcastJid : mucRoomEntity.getOutcasts()) {
                room.addOutcast(new JID(outcastJid), null, room.getRole());
            }
        }
    }

    public void addAdmin(String serviceName, String roomName, String jid) throws MUCServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            room.addAdmin(new JID(jid), room.getRole());
        }
        catch (ForbiddenException e) {
            LOG.error("Could not add admin", (Throwable)e);
            throw new MUCServiceException("Could not add admin", jid, "ForbiddenException");
        }
        catch (ConflictException e) {
            LOG.error("Could not add admin", (Throwable)e);
            throw new MUCServiceException("Could not add admin", jid, "ConflictException");
        }
    }

    public void addOwner(String serviceName, String roomName, String jid) throws MUCServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            room.addOwner(new JID(jid), room.getRole());
        }
        catch (ForbiddenException e) {
            LOG.error("Could not add owner", (Throwable)e);
            throw new MUCServiceException("Could not add owner", jid, "ForbiddenException");
        }
    }

    public void addMember(String serviceName, String roomName, String jid) throws MUCServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            room.addMember(new JID(jid), null, room.getRole());
        }
        catch (ForbiddenException e) {
            LOG.error("Could not add member", (Throwable)e);
            throw new MUCServiceException("Could not add member", jid, "ForbiddenException");
        }
        catch (ConflictException e) {
            LOG.error("Could not add member", (Throwable)e);
            throw new MUCServiceException("Could not add member", jid, "ConflictException");
        }
    }

    public void addOutcast(String serviceName, String roomName, String jid) throws MUCServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            room.addOutcast(new JID(jid), null, room.getRole());
        }
        catch (NotAllowedException e) {
            LOG.error("Could not add outcast", (Throwable)e);
            throw new MUCServiceException("Could not add outcast", jid, "NotAllowedException");
        }
        catch (ForbiddenException e) {
            LOG.error("Could not add outcast", (Throwable)e);
            throw new MUCServiceException("Could not add outcast", jid, "ForbiddenException");
        }
        catch (ConflictException e) {
            LOG.error("Could not add outcast", (Throwable)e);
            throw new MUCServiceException("Could not add outcast", jid, "ConflictException");
        }
    }

    public void deleteAffiliation(String serviceName, String roomName, String jid) throws MUCServiceException {
        MUCRoom room = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceName).getChatRoom(roomName.toLowerCase());
        try {
            room.addNone(new JID(jid), room.getRole());
        }
        catch (ForbiddenException e) {
            LOG.error("Could not delete affiliation", (Throwable)e);
            throw new MUCServiceException("Could not delete affiliation", jid, "ForbiddenException");
        }
        catch (ConflictException e) {
            LOG.error("Could not delete affiliation", (Throwable)e);
            throw new MUCServiceException("Could not delete affiliation", jid, "ConflictException");
        }
    }
}

