/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.servlet;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.ConnectionException;
import org.jivesoftware.openfire.auth.InternalUnauthenticatedException;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.plugin.servlet.BasicAuth;

public class AuthFilter
implements ContainerRequestFilter {
    public ContainerRequest filter(ContainerRequest containerRequest) throws WebApplicationException {
        String auth = containerRequest.getHeaderValue("authorization");
        if (auth == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String[] lap = BasicAuth.decode(auth);
        if (lap == null || lap.length != 2) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        boolean userAdmin = AdminManager.getInstance().isUserAdmin(lap[0], true);
        if (!userAdmin) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        try {
            AuthFactory.authenticate((String)lap[0], (String)lap[1]);
        }
        catch (UnauthorizedException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (ConnectionException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (InternalUnauthenticatedException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return containerRequest;
    }
}

