/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.service;

import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.entity.MUCRoomEntities;
import org.jivesoftware.openfire.entity.MUCRoomEntity;
import org.jivesoftware.openfire.entity.ParticipantEntities;
import org.jivesoftware.openfire.exception.MUCServiceException;
import org.jivesoftware.openfire.plugin.MUCRoomController;

@Path(value="mucservice/chatrooms")
public class MUCRoomService {
    @GET
    @Produces(value={"application/xml"})
    public MUCRoomEntities getMUCRooms(@DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @DefaultValue(value="public") @QueryParam(value="type") String channelType, @QueryParam(value="search") String roomSearch) {
        return MUCRoomController.getInstance().getChatRooms(serviceName, channelType, roomSearch);
    }

    @GET
    @Path(value="/{roomName}")
    @Produces(value={"application/xml"})
    public MUCRoomEntity getMUCRoom(@PathParam(value="roomName") String roomName, @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) throws MUCServiceException {
        return MUCRoomController.getInstance().getChatRoom(roomName, serviceName);
    }

    @DELETE
    @Path(value="/{roomName}")
    public Response deleteMUCRoom(@PathParam(value="roomName") String roomName, @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) throws MUCServiceException {
        MUCRoomController.getInstance().deleteChatRoom(roomName, serviceName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    public Response createMUCRoom(@DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, MUCRoomEntity mucRoomEntity) throws MUCServiceException {
        MUCRoomController.getInstance().createChatRoom(serviceName, mucRoomEntity);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/{roomName}")
    public Response udpateMUCRoom(@PathParam(value="roomName") String roomName, @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, MUCRoomEntity mucRoomEntity) throws MUCServiceException {
        MUCRoomController.getInstance().updateChatRoom(roomName, serviceName, mucRoomEntity);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{roomName}/participants")
    @Produces(value={"application/xml"})
    public ParticipantEntities getMUCRoomParticipants(@PathParam(value="roomName") String roomName, @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) {
        return MUCRoomController.getInstance().getRoomParticipants(roomName, serviceName);
    }
}

