/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.directwebremoting.json.JsonUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReCaptchaUtil {
    private static final Logger Log = LoggerFactory.getLogger(ReCaptchaUtil.class);
    private static final String RECAPTCHA_ENABLED = "registration.recaptcha.enabled";
    private static final String RECAPTCHA_MINIMAL_SCORE = "registration.recaptcha.score.minimal";
    private static final String RECAPTCHA_SITE_KEY = "registration.recaptcha.key.site";
    private static final String RECAPTCHA_SECRET_KEY = "registration.recaptcha.key.secret";

    public static void setReCaptchaEnabled(boolean enable) {
        JiveGlobals.setProperty((String)RECAPTCHA_ENABLED, (String)(enable ? "true" : "false"));
    }

    public static boolean reCaptchaEnabled() {
        return JiveGlobals.getBooleanProperty((String)RECAPTCHA_ENABLED, (boolean)false);
    }

    public static void setReCaptchaMinimalScore(double score) {
        JiveGlobals.setProperty((String)RECAPTCHA_MINIMAL_SCORE, (String)Double.toString(score));
    }

    public static double getReCaptchaMinimalScore() {
        return Double.parseDouble(JiveGlobals.getProperty((String)RECAPTCHA_MINIMAL_SCORE, (String)"0.5"));
    }

    public static void setReCaptchaSiteKey(String siteKey) {
        JiveGlobals.setProperty((String)RECAPTCHA_SITE_KEY, (String)siteKey);
    }

    public static String getReCaptchaSiteKey() {
        return JiveGlobals.getProperty((String)RECAPTCHA_SITE_KEY);
    }

    public static void setReCaptchaSecretKey(String secretKey) {
        JiveGlobals.setPropertyEncrypted((String)RECAPTCHA_SECRET_KEY, (boolean)false);
        JiveGlobals.setProperty((String)RECAPTCHA_SECRET_KEY, (String)secretKey);
    }

    public static String getReCaptchaSecretKey() {
        return JiveGlobals.getProperty((String)RECAPTCHA_SECRET_KEY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verify(String recaptchaResponse, String remoteIP) {
        Log.debug("Verifying reCaptcha response from '{}'", (Object)remoteIP);
        try {
            String secret = URLEncoder.encode(ReCaptchaUtil.getReCaptchaSecretKey(), StandardCharsets.UTF_8.toString());
            String response = URLEncoder.encode(recaptchaResponse, StandardCharsets.UTF_8.toString());
            String ip = URLEncoder.encode(remoteIP, StandardCharsets.UTF_8.toString());
            String entity = "secret=" + secret + "&response=" + response + "&remoteip=" + ip;
            URL url = new URL("https://www.google.com/recaptcha/api/siteverify");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                wr.writeBytes(entity);
                wr.flush();
            }
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                Log.debug("Failed reCaptcha verification of '{}': Google's service responded with status code {}", new Object[]{remoteIP, responseCode});
                return false;
            }
            try (InputStreamReader in = new InputStreamReader(con.getInputStream());){
                Map json = JsonUtil.toSimpleObject((Reader)in);
                if (!json.get("success").equals(true)) {
                    Log.debug("Failed reCaptcha verification of '{}': Google's service did not respond with 'success'.", (Object)remoteIP);
                    boolean bl = false;
                    return bl;
                }
                double score = (Double)json.get("score");
                if (!(score >= ReCaptchaUtil.getReCaptchaMinimalScore())) {
                    Log.debug("Failed reCaptcha verification of '{}': Google's service responded with score {}. Minimal score to pass is: {}", new Object[]{remoteIP, score, ReCaptchaUtil.getReCaptchaMinimalScore()});
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            Log.warn("Failed reCaptcha verification of '{}': An exception occurred.", (Object)new Object[]{remoteIP}, (Object)e);
            return false;
        }
    }
}

