/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest;

import java.io.IOException;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.ConnectionException;
import org.jivesoftware.openfire.auth.InternalUnauthenticatedException;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.plugin.rest.BasicAuth;
import org.jivesoftware.openfire.plugin.rest.RESTServicePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=2000)
public class AuthFilter
implements ContainerRequestFilter {
    private static Logger LOG = LoggerFactory.getLogger(AuthFilter.class);
    @Context
    private HttpServletRequest httpRequest;
    private RESTServicePlugin plugin = (RESTServicePlugin)XMPPServer.getInstance().getPluginManager().getPlugin("restapi");

    public void filter(ContainerRequestContext containerRequest) throws IOException {
        String auth;
        if (containerRequest.getUriInfo().getRequestUri().getPath().equals("/plugins/restapi/v1/openapi.yaml")) {
            LOG.debug("Authentication was bypassed for openapi.yaml file (documentation)");
            return;
        }
        if (this.isStatusEndpoint(containerRequest.getUriInfo().getRequestUri().getPath())) {
            LOG.debug("Authentication was bypassed for a status endpoint");
            return;
        }
        if (!this.plugin.isEnabled()) {
            LOG.debug("REST API Plugin is not enabled");
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if ("OPTIONS".equals(containerRequest.getMethod())) {
            LOG.debug("Authentication was bypassed because of OPTIONS request");
            return;
        }
        if (containerRequest.getUriInfo().getRequestUri().getPath().contains("restapi/v1/userservice")) {
            LOG.info("Deprecated 'userservice' endpoint was used. Please switch to the new endpoints");
            return;
        }
        if (!this.plugin.getAllowedIPs().isEmpty()) {
            String ipAddress = this.httpRequest.getHeader("x-forwarded-for");
            if (ipAddress == null && (ipAddress = this.httpRequest.getHeader("X_FORWARDED_FOR")) == null && (ipAddress = this.httpRequest.getHeader("X-Forward-For")) == null) {
                ipAddress = this.httpRequest.getRemoteAddr();
            }
            if (!this.plugin.getAllowedIPs().contains(ipAddress)) {
                LOG.warn("REST API rejected service for IP address: " + ipAddress);
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        if ((auth = containerRequest.getHeaderString("authorization")) == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if ("basic".equals(this.plugin.getHttpAuth())) {
            String[] usernameAndPassword = BasicAuth.decode(auth);
            if (usernameAndPassword == null || usernameAndPassword.length != 2) {
                LOG.warn("Username or password is not set");
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            boolean userAdmin = AdminManager.getInstance().isUserAdmin(usernameAndPassword[0], true);
            if (!userAdmin) {
                LOG.warn("Provided User is not an admin");
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            try {
                AuthFactory.authenticate((String)usernameAndPassword[0], (String)usernameAndPassword[1]);
            }
            catch (UnauthorizedException e) {
                LOG.warn("Wrong HTTP Basic Auth authorization", (Throwable)e);
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (ConnectionException e) {
                LOG.error("Authentication went wrong", (Throwable)e);
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (InternalUnauthenticatedException e) {
                LOG.error("Authentication went wrong", (Throwable)e);
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        } else if (!auth.equals(this.plugin.getSecret())) {
            LOG.warn("Wrong secret key authorization. Provided key: " + auth);
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private boolean isStatusEndpoint(String path) {
        return path.equals("/plugins/restapi/v1/system/liveness") || path.startsWith("/plugins/restapi/v1/system/liveness/") || path.equals("/plugins/restapi/v1/system/readiness") || path.startsWith("/plugins/restapi/v1/system/readiness/");
    }
}

