/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.admin.AuthCheckFilter;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.plugin.rest.StatisticsFilter;
import org.jivesoftware.openfire.plugin.rest.service.JerseyWrapper;
import org.jivesoftware.openfire.stats.Statistic;
import org.jivesoftware.openfire.stats.StatisticsManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.StringUtils;

public class RESTServicePlugin
implements Plugin,
PropertyEventListener {
    private static final String CUSTOM_AUTH_FILTER_PROPERTY_NAME = "plugin.restapi.customAuthFilter";
    public static final String SERVICE_LOGGING_ENABLED = "plugin.restapi.serviceLoggingEnabled";
    private String secret;
    private Collection<String> allowedIPs;
    private boolean enabled;
    private boolean serviceLoggingEnabled;
    private String httpAuth;
    private String customAuthFilterClassName;
    private final Set<String> registeredStatisticKeys = new HashSet<String>();

    public boolean isServiceLoggingEnabled() {
        return this.serviceLoggingEnabled;
    }

    public void setServiceLoggingEnabled(boolean serviceLoggingEnabled) {
        JiveGlobals.setProperty((String)SERVICE_LOGGING_ENABLED, (String)Boolean.toString(serviceLoggingEnabled));
        this.serviceLoggingEnabled = serviceLoggingEnabled;
    }

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        this.secret = JiveGlobals.getProperty((String)"plugin.restapi.secret", (String)"");
        if ("".equals(this.secret)) {
            this.secret = StringUtils.randomString((int)16);
            this.setSecret(this.secret);
        }
        this.customAuthFilterClassName = JiveGlobals.getProperty((String)CUSTOM_AUTH_FILTER_PROPERTY_NAME, (String)"");
        for (StatisticsFilter.RestResponseFamilyStatistic statistic : StatisticsFilter.generateAllFamilyStatisticInstances()) {
            StatisticsManager.getInstance().addStatistic(statistic.getKeyName(), (Statistic)statistic);
            this.registeredStatisticKeys.add(statistic.getKeyName());
        }
        this.enabled = JiveGlobals.getBooleanProperty((String)"plugin.restapi.enabled", (boolean)false);
        this.httpAuth = JiveGlobals.getProperty((String)"plugin.restapi.httpAuth", (String)"basic");
        this.allowedIPs = StringUtils.stringToCollection((String)JiveGlobals.getProperty((String)"plugin.restapi.allowedIPs", (String)""));
        this.setServiceLoggingEnabled(JiveGlobals.getBooleanProperty((String)SERVICE_LOGGING_ENABLED, (boolean)false));
        PropertyEventDispatcher.addListener((PropertyEventListener)this);
        AuthCheckFilter.addExclude((String)"restapi/*");
    }

    public void destroyPlugin() {
        Iterator<String> iter = this.registeredStatisticKeys.iterator();
        while (iter.hasNext()) {
            StatisticsManager.getInstance().removeStatistic(iter.next());
            iter.remove();
        }
        AuthCheckFilter.removeExclude((String)"restapi/*");
        PropertyEventDispatcher.removeListener((PropertyEventListener)this);
    }

    public String getLoadingStatusMessage() {
        return JerseyWrapper.getLoadingStatusMessage();
    }

    public String loadAuthenticationFilter(String customAuthFilterClassName) {
        return JerseyWrapper.tryLoadingAuthenticationFilter(customAuthFilterClassName);
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        JiveGlobals.setProperty((String)"plugin.restapi.secret", (String)secret);
        this.secret = secret;
    }

    public String getCustomAuthFilterClassName() {
        return this.customAuthFilterClassName;
    }

    public void setCustomAuthFiIterClassName(String customAuthFilterClassName) {
        JiveGlobals.setProperty((String)CUSTOM_AUTH_FILTER_PROPERTY_NAME, (String)customAuthFilterClassName);
        this.customAuthFilterClassName = customAuthFilterClassName;
    }

    public Collection<String> getAllowedIPs() {
        return this.allowedIPs;
    }

    public void setAllowedIPs(Collection<String> allowedIPs) {
        JiveGlobals.setProperty((String)"plugin.restapi.allowedIPs", (String)StringUtils.collectionToString(allowedIPs));
        this.allowedIPs = allowedIPs;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        JiveGlobals.setProperty((String)"plugin.restapi.enabled", (String)(enabled ? "true" : "false"));
    }

    public String getHttpAuth() {
        return this.httpAuth;
    }

    public void setHttpAuth(String httpAuth) {
        this.httpAuth = httpAuth;
        JiveGlobals.setProperty((String)"plugin.restapi.httpAuth", (String)httpAuth);
    }

    public void propertySet(String property, Map<String, Object> params) {
        if (property.equals("plugin.restapi.secret")) {
            this.secret = (String)params.get("value");
        } else if (property.equals("plugin.restapi.enabled")) {
            this.enabled = Boolean.parseBoolean((String)params.get("value"));
        } else if (property.equals("plugin.restapi.allowedIPs")) {
            this.allowedIPs = StringUtils.stringToCollection((String)((String)params.get("value")));
        } else if (property.equals("plugin.restapi.httpAuth")) {
            this.httpAuth = (String)params.get("value");
        } else if (property.equals(CUSTOM_AUTH_FILTER_PROPERTY_NAME)) {
            this.customAuthFilterClassName = (String)params.get("value");
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
        if (property.equals("plugin.restapi.secret")) {
            this.secret = "";
        } else if (property.equals("plugin.restapi.enabled")) {
            this.enabled = false;
        } else if (property.equals("plugin.restapi.allowedIPs")) {
            this.allowedIPs = Collections.emptyList();
        } else if (property.equals("plugin.restapi.httpAuth")) {
            this.httpAuth = "basic";
        } else if (property.equals(CUSTOM_AUTH_FILTER_PROPERTY_NAME)) {
            this.customAuthFilterClassName = null;
        }
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }
}

