/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.stats.Statistic;
import org.jivesoftware.openfire.stats.i18nStatistic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsFilter
implements ContainerResponseFilter {
    private static final Logger Log = LoggerFactory.getLogger(StatisticsFilter.class);
    private static final ConcurrentMap<Response.Status.Family, Long> ratePerFamily = new ConcurrentHashMap<Response.Status.Family, Long>();

    private static ConcurrentMap<Response.Status.Family, Long> getStatsCollection() {
        return ratePerFamily;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Response.StatusType statusInfo = responseContext.getStatusInfo();
        if (statusInfo == null) {
            Log.warn("Cannot record statistics for a response that contains no status info. Response context object: {}", (Object)responseContext);
        } else {
            StatisticsFilter.getStatsCollection().merge(statusInfo.getFamily(), 1L, Long::sum);
        }
    }

    public static Collection<RestResponseFamilyStatistic> generateAllFamilyStatisticInstances() {
        HashSet<RestResponseFamilyStatistic> result = new HashSet<RestResponseFamilyStatistic>();
        for (Response.Status.Family family : Response.Status.Family.values()) {
            result.add(new RestResponseFamilyStatistic(family));
        }
        return result;
    }

    public static class RestResponseFamilyStatistic
    extends i18nStatistic {
        public static final String GROUP = "restapi_responses";
        private final Response.Status.Family family;

        public RestResponseFamilyStatistic(@Nonnull Response.Status.Family family) {
            super("restapi_responses." + family.toString().toLowerCase(), "restapi", Statistic.Type.rate);
            this.family = family;
        }

        public double sample() {
            Long oldValue = StatisticsFilter.getStatsCollection().replace(this.family, 0L);
            return oldValue == null ? 0.0 : (double)oldValue.longValue();
        }

        public boolean isPartialSample() {
            return true;
        }

        public String getGroupName() {
            return GROUP;
        }

        public String getKeyName() {
            return this.family.toString().toLowerCase();
        }
    }
}

