/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.plugin.rest.entity.MUCServiceEntities;
import org.jivesoftware.openfire.plugin.rest.entity.MUCServiceEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.util.AlreadyExistsException;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MUCServiceController {
    private static final Logger LOG = LoggerFactory.getLogger(MUCServiceController.class);
    private static MUCServiceController INSTANCE = null;

    public static MUCServiceController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MUCServiceController();
        }
        return INSTANCE;
    }

    public static void log(String logMessage) {
        if (JiveGlobals.getBooleanProperty((String)"plugin.restapi.serviceLoggingEnabled", (boolean)false)) {
            LOG.info(logMessage);
        }
    }

    @Nonnull
    protected static MultiUserChatService getService(@Nonnull String serviceName) throws ServiceException {
        Set services = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatServices().stream().filter(multiUserChatService -> multiUserChatService.getServiceName().equalsIgnoreCase(serviceName)).collect(Collectors.toSet());
        if (services.isEmpty()) {
            throw new ServiceException("Chat service does not exist or is not accessible.", serviceName, "MUCServiceNotFoundException", Response.Status.NOT_FOUND);
        }
        if (services.size() > 1) {
            Optional<MultiUserChatService> exactMatch = services.stream().filter(multiUserChatService -> multiUserChatService.getServiceName().equals(serviceName)).findAny();
            if (exactMatch.isPresent()) {
                return exactMatch.get();
            }
            LOG.warn("Found multiple services matching the service name '{}' when doing a case-insensitive lookup, but none when doing a case-sensitive lookup. Returning an arbitrary one of those that match case-insensitively.", (Object)serviceName);
        }
        return (MultiUserChatService)services.iterator().next();
    }

    public void createChatService(MUCServiceEntity mucServiceEntity) throws ServiceException {
        MUCServiceController.log("Create a chat service: " + mucServiceEntity.getServiceName());
        try {
            this.createService(mucServiceEntity);
        }
        catch (ForbiddenException | NotAllowedException e) {
            throw new ServiceException("Could not create the chat service", mucServiceEntity.getServiceName(), "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not create the chat service", mucServiceEntity.getServiceName(), "NotAllowedException", Response.Status.CONFLICT, e);
        }
        catch (AlreadyExistsException e) {
            throw new ServiceException("Could not create the chat service", mucServiceEntity.getServiceName(), "AlreadyExistsException", Response.Status.CONFLICT, e);
        }
    }

    private void createService(MUCServiceEntity mucServiceEntity) throws NotAllowedException, ForbiddenException, ConflictException, AlreadyExistsException {
        MUCServiceController.log("Create a chat service: " + mucServiceEntity.getServiceName());
        XMPPServer.getInstance().getMultiUserChatManager().createMultiUserChatService(mucServiceEntity.getServiceName(), mucServiceEntity.getDescription(), mucServiceEntity.isHidden());
    }

    public MUCServiceEntities getChatServices() {
        return new MUCServiceEntities(XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatServices().stream().map(mucs -> new MUCServiceEntity(mucs.getServiceName(), mucs.getDescription(), mucs.isHidden())).collect(Collectors.toList()));
    }
}

