/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.http.HttpBindManager;
import org.jivesoftware.openfire.plugin.rest.entity.SystemProperties;
import org.jivesoftware.openfire.plugin.rest.entity.SystemProperty;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.spi.ConnectionListener;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemController {
    private static final Logger LOG = LoggerFactory.getLogger(SystemController.class);
    private static SystemController INSTANCE = null;

    public static SystemController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SystemController();
        }
        return INSTANCE;
    }

    @Deprecated
    public static void setInstance(SystemController instance) {
        INSTANCE = instance;
    }

    public static void log(String logMessage) {
        if (JiveGlobals.getBooleanProperty((String)"plugin.restapi.serviceLoggingEnabled", (boolean)false)) {
            LOG.info(logMessage);
        }
    }

    public SystemProperties getSystemProperties() {
        Collection systemProperties = org.jivesoftware.util.SystemProperty.getProperties();
        Set systemPropertyKeys = systemProperties.stream().map(org.jivesoftware.util.SystemProperty::getKey).collect(Collectors.toSet());
        List<SystemProperty> compoundProperties = systemProperties.stream().map(p -> new SystemProperty(p.getKey(), p.getValueAsSaved())).collect(Collectors.toList());
        JiveGlobals.getPropertyNames().stream().filter(key -> !systemPropertyKeys.contains(key)).forEach(key -> compoundProperties.add(new SystemProperty((String)key, JiveGlobals.getProperty((String)key))));
        compoundProperties.sort(Comparator.comparing(SystemProperty::getKey));
        SystemProperties result = new SystemProperties();
        result.setProperties(compoundProperties);
        return result;
    }

    public SystemProperty getSystemProperty(String propertyKey) throws ServiceException {
        String propertyValue = JiveGlobals.getProperty((String)propertyKey);
        if (propertyValue != null) {
            return new SystemProperty(propertyKey, propertyValue);
        }
        throw new ServiceException("Could not find property", propertyKey, "PropertyNotFoundException", Response.Status.NOT_FOUND);
    }

    public void createSystemProperty(SystemProperty systemProperty) {
        JiveGlobals.setProperty((String)systemProperty.getKey(), (String)systemProperty.getValue());
    }

    public void deleteSystemProperty(String propertyKey) throws ServiceException {
        if (JiveGlobals.getProperty((String)propertyKey) == null) {
            throw new ServiceException("Could not find property", propertyKey, "PropertyNotFoundException", Response.Status.NOT_FOUND);
        }
        JiveGlobals.deleteProperty((String)propertyKey);
    }

    public void updateSystemProperty(String propertyKey, SystemProperty systemProperty) throws ServiceException {
        if (JiveGlobals.getProperty((String)propertyKey) != null) {
            if (!systemProperty.getKey().equals(propertyKey)) {
                throw new ServiceException("Path property name and entity property name doesn't match", propertyKey, "IllegalArgumentException", Response.Status.BAD_REQUEST);
            }
        } else {
            throw new ServiceException("Could not find property for update", systemProperty.getKey(), "PropertyNotFoundException", Response.Status.NOT_FOUND);
        }
        JiveGlobals.setProperty((String)propertyKey, (String)systemProperty.getValue());
    }

    public boolean hasDeadlock() {
        try {
            return ManagementFactory.getThreadMXBean().findDeadlockedThreads() != null;
        }
        catch (Throwable t) {
            LOG.warn("Unable to determine if there is a deadlock.", t);
            return false;
        }
    }

    public boolean hasSystemPropertyRequiringRestart() {
        try {
            org.jivesoftware.util.SystemProperty.getProperties().stream().filter(org.jivesoftware.util.SystemProperty::isRestartRequired).forEach(p -> LOG.info("Requires restart: {}. Current value: {}. Initial value: {}", new Object[]{p.getKey(), p.getValue(), p.getDisplayValue()}));
            return org.jivesoftware.util.SystemProperty.getProperties().stream().filter(systemProperty -> !systemProperty.getKey().equals("xmpp.domain")).anyMatch(org.jivesoftware.util.SystemProperty::isRestartRequired);
        }
        catch (Throwable t) {
            LOG.warn("Unable to determine if there are any system properties that require a restart.", t);
            return false;
        }
    }

    public boolean isStarted() {
        return XMPPServer.getInstance().isStarted();
    }

    public boolean hasClusteringStartedWhenEnabled() {
        if (!ClusterManager.isClusteringEnabled()) {
            return true;
        }
        return ClusterManager.isClusteringStarted();
    }

    public boolean hasPluginManagerExecuted() {
        return XMPPServer.getInstance().getPluginManager().isExecuted();
    }

    public boolean isConnectionListenerStartedWhenEnabled(@Nonnull ConnectionType connectionType, boolean encrypted) {
        switch (connectionType) {
            case BOSH_C2S: {
                if (encrypted) {
                    return (Boolean)HttpBindManager.HTTP_BIND_ENABLED.getValue() == false || (Integer)HttpBindManager.HTTP_BIND_SECURE_PORT.getValue() <= 0 || HttpBindManager.getInstance().isHttpsBindActive();
                }
                return (Boolean)HttpBindManager.HTTP_BIND_ENABLED.getValue() == false || (Integer)HttpBindManager.HTTP_BIND_PORT.getValue() <= 0 || HttpBindManager.getInstance().isHttpBindActive();
            }
            case WEBADMIN: {
                return true;
            }
            case SOCKET_S2S: {
                return true;
            }
        }
        ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
        if (connectionManager == null) {
            return false;
        }
        ConnectionListener listener = connectionManager.getListener(connectionType, encrypted);
        if (listener == null) {
            return false;
        }
        return !listener.isEnabled() || listener.getSocketAcceptor() != null;
    }

    public boolean areConnectionListenersStarted() {
        for (ConnectionType connectionType : ConnectionType.values()) {
            if (!this.isConnectionListenerStartedWhenEnabled(connectionType, true)) {
                return false;
            }
            if (this.isConnectionListenerStartedWhenEnabled(connectionType, false)) continue;
            return false;
        }
        return true;
    }
}

