/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.lockout.LockOutManager;
import org.jivesoftware.openfire.plugin.rest.controller.GroupController;
import org.jivesoftware.openfire.plugin.rest.controller.JustMarriedController;
import org.jivesoftware.openfire.plugin.rest.dao.PropertyDAO;
import org.jivesoftware.openfire.plugin.rest.entity.GroupEntity;
import org.jivesoftware.openfire.plugin.rest.entity.RosterEntities;
import org.jivesoftware.openfire.plugin.rest.entity.RosterItemEntity;
import org.jivesoftware.openfire.plugin.rest.entity.UserEntities;
import org.jivesoftware.openfire.plugin.rest.entity.UserEntity;
import org.jivesoftware.openfire.plugin.rest.entity.UserGroupsEntity;
import org.jivesoftware.openfire.plugin.rest.entity.UserProperty;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.plugin.rest.utils.UserUtils;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.StreamError;

public class UserServiceController {
    private static final Logger LOG = LoggerFactory.getLogger(UserServiceController.class);
    private static UserServiceController INSTANCE = null;
    private final UserManager userManager;
    private final RosterManager rosterManager;
    private final XMPPServer server = XMPPServer.getInstance();
    private final LockOutManager lockOutManager;

    public static UserServiceController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserServiceController();
        }
        return INSTANCE;
    }

    @Deprecated
    public static void setInstance(UserServiceController instance) {
        INSTANCE = instance;
    }

    private UserServiceController() {
        this.userManager = this.server.getUserManager();
        this.rosterManager = this.server.getRosterManager();
        this.lockOutManager = this.server.getLockOutManager();
    }

    public static void log(String logMessage) {
        if (JiveGlobals.getBooleanProperty((String)"plugin.restapi.serviceLoggingEnabled", (boolean)false)) {
            LOG.info(logMessage);
        }
    }

    public void createUser(UserEntity userEntity) throws ServiceException {
        if (userEntity != null && !userEntity.getUsername().isEmpty()) {
            if (userEntity.getPassword() == null) {
                throw new ServiceException("Could not create new user, because password is null", userEntity.getUsername(), "PasswordIsNull", Response.Status.BAD_REQUEST);
            }
            UserServiceController.log("Create a new user: " + userEntity.getUsername());
            try {
                this.userManager.createUser(userEntity.getUsername(), userEntity.getPassword(), userEntity.getName(), userEntity.getEmail());
            }
            catch (UserAlreadyExistsException e) {
                throw new ServiceException("Could not create new user", userEntity.getUsername(), "UserAlreadyExistsException", Response.Status.CONFLICT);
            }
        } else {
            throw new ServiceException("Could not create new user", "users", "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        this.addProperties(userEntity.getUsername(), userEntity.getProperties());
    }

    public void updateUser(String username, UserEntity userEntity) throws ServiceException {
        if (userEntity != null && !username.isEmpty()) {
            UserServiceController.log("Update the user: " + userEntity.getUsername());
            if (userEntity.getUsername() != null && !userEntity.getUsername().equals(username)) {
                JustMarriedController.changeName(username, userEntity.getUsername(), true, userEntity.getEmail(), userEntity.getName());
                this.addProperties(userEntity.getUsername(), userEntity.getProperties());
                return;
            }
            User user = this.getAndCheckUser(username);
            if (userEntity.getPassword() != null) {
                user.setPassword(userEntity.getPassword());
            }
            if (userEntity.getName() != null) {
                user.setName(userEntity.getName());
            }
            if (userEntity.getEmail() != null) {
                user.setEmail(userEntity.getEmail());
            }
            this.addProperties(username, userEntity.getProperties());
        }
    }

    public void deleteUser(String username) throws ServiceException {
        UserServiceController.log("Delete the user: " + username);
        User user = this.getAndCheckUser(username);
        this.userManager.deleteUser(user);
        this.rosterManager.deleteRoster(this.server.createJID(username, null));
    }

    public UserEntities getUserEntities(String userSearch, String propertyKey, String propertyValue) throws ServiceException {
        if (propertyKey != null) {
            UserServiceController.log("Get users by property");
            return this.getUserEntitiesByProperty(propertyKey, propertyValue);
        }
        UserServiceController.log("Get all users");
        UserEntities userEntities = new UserEntities();
        userEntities.setUsers(UserUtils.convertUsersToUserEntities(this.userManager.getUsers(), userSearch));
        return userEntities;
    }

    public UserEntity getUserEntity(String username) throws ServiceException {
        UserServiceController.log("Get user entity from user: " + username);
        return UserUtils.convertUserToUserEntity(this.getAndCheckUser(username));
    }

    public void enableUser(String username) throws ServiceException {
        UserServiceController.log("Enable the user: " + username);
        this.getAndCheckUser(username);
        this.lockOutManager.enableAccount(username);
    }

    public void disableUser(String username) throws ServiceException {
        UserServiceController.log("Disable the user: " + username);
        this.getAndCheckUser(username);
        this.lockOutManager.disableAccount(username, null, null);
        if (this.lockOutManager.isAccountDisabled(username)) {
            StreamError error = new StreamError(StreamError.Condition.not_authorized);
            for (ClientSession session : SessionManager.getInstance().getSessions(username)) {
                session.deliverRawText(error.toXML());
                session.close();
            }
        }
    }

    public RosterEntities getRosterEntities(String username) throws ServiceException {
        UserServiceController.log("Get roster entities for user: " + username);
        Roster roster = this.getUserRoster(username);
        ArrayList<RosterItemEntity> rosterEntities = new ArrayList<RosterItemEntity>();
        for (RosterItem rosterItem : roster.getRosterItems()) {
            RosterItemEntity rosterItemEntity = new RosterItemEntity(rosterItem.getJid().toBareJID(), rosterItem.getNickname(), rosterItem.getSubStatus().getValue());
            rosterItemEntity.setGroups(rosterItem.getGroups());
            rosterEntities.add(rosterItemEntity);
        }
        return new RosterEntities(rosterEntities);
    }

    public void addRosterItem(String username, RosterItemEntity rosterItemEntity) throws ServiceException, UserAlreadyExistsException, SharedGroupException, UserNotFoundException {
        Roster roster = this.getUserRoster(username);
        if (rosterItemEntity.getJid() == null) {
            throw new ServiceException("JID is null", "JID", "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        JID jid = new JID(rosterItemEntity.getJid());
        UserServiceController.log("Adding a roster item to: " + rosterItemEntity.getJid());
        try {
            roster.getRosterItem(jid);
            throw new UserAlreadyExistsException(jid.toBareJID());
        }
        catch (UserNotFoundException userNotFoundException) {
            RosterItem rosterItem = roster.createRosterItem(jid, rosterItemEntity.getNickname(), rosterItemEntity.getGroups(), false, true);
            UserUtils.checkSubType(rosterItemEntity.getSubscriptionType());
            rosterItem.setSubStatus(RosterItem.SubType.getTypeFromInt((int)rosterItemEntity.getSubscriptionType()));
            roster.updateRosterItem(rosterItem);
            return;
        }
    }

    public void updateRosterItem(String username, String rosterJid, RosterItemEntity rosterItemEntity) throws ServiceException, UserNotFoundException, UserAlreadyExistsException, SharedGroupException {
        UserServiceController.log("Updating a roster item for user: " + username + ", with roster JID: " + rosterJid);
        this.getAndCheckUser(username);
        Roster roster = this.getUserRoster(username);
        JID jid = new JID(rosterJid);
        RosterItem rosterItem = roster.getRosterItem(jid);
        if (rosterItemEntity.getNickname() != null) {
            rosterItem.setNickname(rosterItemEntity.getNickname());
        }
        if (rosterItemEntity.getGroups() != null) {
            rosterItem.setGroups(rosterItemEntity.getGroups());
        }
        UserUtils.checkSubType(rosterItemEntity.getSubscriptionType());
        rosterItem.setSubStatus(RosterItem.SubType.getTypeFromInt((int)rosterItemEntity.getSubscriptionType()));
        roster.updateRosterItem(rosterItem);
    }

    public void deleteRosterItem(String username, String rosterJid) throws SharedGroupException, ServiceException {
        UserServiceController.log("Deleting a roster item for user: " + username + ", with roster JID: " + rosterJid);
        this.getAndCheckUser(username);
        Roster roster = this.getUserRoster(username);
        JID jid = new JID(rosterJid);
        if (roster.deleteRosterItem(jid, true) == null) {
            throw new ServiceException("Roster Item could not deleted", jid.toBareJID(), "RosterItemNotFound", Response.Status.NOT_FOUND);
        }
    }

    public List<String> getUserGroups(String username) throws ServiceException {
        UserServiceController.log("Get user groups for user: " + username);
        if (username.contains("@")) {
            JID jid = new JID(username);
            if (jid.getDomain().equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = jid.getNode();
            } else {
                throw new ServiceException("This service cannot be used for non-local users.", username, "GroupNotFoundException", Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        User user = this.getAndCheckUser(username);
        Collection groups = GroupManager.getInstance().getGroups(user);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    public void addUserToGroups(String username, UserGroupsEntity userGroupsEntity) throws ServiceException {
        if (userGroupsEntity != null) {
            UserServiceController.log("Adding user: " + username + " to groups");
            ArrayList<Group> groups = new ArrayList<Group>();
            for (String groupName : userGroupsEntity.getGroupNames()) {
                Group group;
                try {
                    group = GroupManager.getInstance().getGroup(groupName);
                    UserServiceController.log("Adding user: " + username + " to a group: " + groupName);
                }
                catch (GroupNotFoundException e) {
                    group = GroupController.getInstance().createGroup(new GroupEntity(groupName, ""));
                }
                groups.add(group);
            }
            for (Group group : groups) {
                group.getMembers().add(username.contains("@") ? new JID(username) : XMPPServer.getInstance().createJID(username, null));
            }
        }
    }

    public void addUserToGroup(String username, String groupName) throws ServiceException {
        Group group;
        UserServiceController.log("Adding user: " + username + " to a group: " + groupName);
        try {
            group = GroupManager.getInstance().getGroup(groupName);
        }
        catch (GroupNotFoundException e) {
            UserServiceController.log("Group: " + groupName + " does not exist. Creating the group");
            group = GroupController.getInstance().createGroup(new GroupEntity(groupName, ""));
        }
        group.getMembers().add(username.contains("@") ? new JID(username) : XMPPServer.getInstance().createJID(username, null));
    }

    public void deleteUserFromGroups(String username, UserGroupsEntity userGroupsEntity) throws ServiceException {
        if (userGroupsEntity != null) {
            UserServiceController.log("Removing user: " + username + " from groups");
            for (String groupName : userGroupsEntity.getGroupNames()) {
                Group group;
                UserServiceController.log("deleteUserFromGroups, " + username + ", groupName: " + groupName);
                try {
                    group = GroupManager.getInstance().getGroup(groupName);
                }
                catch (GroupNotFoundException e) {
                    throw new ServiceException("Could not find group", groupName, "GroupNotFoundException", Response.Status.NOT_FOUND, e);
                }
                UserServiceController.log("Removing user: " + username + " from the group: " + groupName);
                group.getMembers().remove(username.contains("@") ? new JID(username) : XMPPServer.getInstance().createJID(username, null));
            }
        }
    }

    public void deleteUserFromGroup(String username, String groupName) throws ServiceException {
        Group group;
        UserServiceController.log("Removing user: " + username + " from the group: " + groupName);
        try {
            group = GroupManager.getInstance().getGroup(groupName);
        }
        catch (GroupNotFoundException e) {
            throw new ServiceException("Could not find group", groupName, "GroupNotFoundException", Response.Status.NOT_FOUND, e);
        }
        group.getMembers().remove(username.contains("@") ? new JID(username) : XMPPServer.getInstance().createJID(username, null));
    }

    public UserEntities getUserEntitiesByProperty(String propertyKey, String propertyValue) throws ServiceException {
        UserServiceController.log("Get user entities by property key : " + propertyKey + "and property value: " + propertyValue);
        List<String> usernames = PropertyDAO.getUsernameByProperty(propertyKey, propertyValue);
        ArrayList<UserEntity> users = new ArrayList<UserEntity>();
        UserEntities userEntities = new UserEntities();
        for (String username : usernames) {
            users.add(this.getUserEntity(username));
        }
        userEntities.setUsers(users);
        return userEntities;
    }

    private void addProperties(String username, List<UserProperty> properties) throws ServiceException {
        UserServiceController.log("Adding a property to user: " + username);
        User user = this.getAndCheckUser(username);
        user.getProperties().clear();
        if (properties != null) {
            for (UserProperty property : properties) {
                user.getProperties().put(property.getKey(), property.getValue());
            }
        }
    }

    private User getAndCheckUser(String username) throws ServiceException {
        JID targetJID = this.server.createJID(username, null);
        if (targetJID.getNode() == null) {
            throw new ServiceException("Could not get user", username, "UserNotFoundException", Response.Status.NOT_FOUND);
        }
        try {
            return this.userManager.getUser(targetJID.getNode());
        }
        catch (UserNotFoundException e) {
            throw new ServiceException("Could not get user", username, "UserNotFoundException", Response.Status.NOT_FOUND, e);
        }
    }

    private Roster getUserRoster(String username) throws ServiceException {
        UserServiceController.log("getUserRoster, " + username);
        try {
            return this.rosterManager.getRoster(username);
        }
        catch (UserNotFoundException e) {
            throw new ServiceException("Could not get user roster", username, "UserNotFoundException", Response.Status.NOT_FOUND, e);
        }
    }
}

