/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.entity;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jivesoftware.openfire.cluster.ClusterNodeInfo;
import org.jivesoftware.openfire.cluster.NodeID;

@XmlRootElement(name="clusterNode")
public class ClusterNodeEntity {
    private String hostName;
    private String nodeID;
    private Date joinedTime;
    private boolean seniorMember;

    @Nonnull
    public static ClusterNodeEntity from(@Nonnull ClusterNodeInfo clusterNodeInfo) {
        return new ClusterNodeEntity(clusterNodeInfo.getHostName(), clusterNodeInfo.getNodeID(), clusterNodeInfo.getJoinedTime(), clusterNodeInfo.isSeniorMember());
    }

    public ClusterNodeEntity() {
    }

    public ClusterNodeEntity(String hostName, NodeID nodeID, long joinedTime, boolean seniorMember) {
        this.hostName = hostName;
        this.nodeID = nodeID == null ? null : nodeID.toString();
        this.joinedTime = joinedTime < 0L ? null : new Date(joinedTime);
        this.seniorMember = seniorMember;
    }

    @XmlElement
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @XmlElement
    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @XmlElement
    public Date getJoinedTime() {
        return this.joinedTime;
    }

    public void setJoinedTime(Date joinedTime) {
        this.joinedTime = joinedTime;
    }

    @XmlElement
    public boolean isSeniorMember() {
        return this.seniorMember;
    }

    public void setSeniorMember(boolean seniorMember) {
        this.seniorMember = seniorMember;
    }
}

