/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jivesoftware.openfire.plugin.rest.entity.RoomCreationResultEntity;

@XmlRootElement(name="results")
@XmlType(propOrder={"successResults", "failureResults", "otherResults"})
public class RoomCreationResultEntities {
    List<RoomCreationResultEntity> successResults = new ArrayList<RoomCreationResultEntity>();
    List<RoomCreationResultEntity> failureResults = new ArrayList<RoomCreationResultEntity>();
    List<RoomCreationResultEntity> otherResults = new ArrayList<RoomCreationResultEntity>();

    public RoomCreationResultEntities() {
    }

    public RoomCreationResultEntities(List<RoomCreationResultEntity> results) {
        this();
        this.addResults(results);
    }

    public void addResults(List<RoomCreationResultEntity> resultsToAdd) {
        resultsToAdd.forEach(this::addResult);
    }

    public void addResult(RoomCreationResultEntity resultToAdd) {
        switch (resultToAdd.getResultType()) {
            case Success: {
                this.successResults.add(resultToAdd);
                break;
            }
            case Failure: {
                this.failureResults.add(resultToAdd);
                break;
            }
            default: {
                this.otherResults.add(resultToAdd);
            }
        }
    }

    @XmlElement(name="result")
    @XmlElementWrapper(name="success")
    @JsonProperty(value="success")
    @Schema(description="All creation results of type success")
    public List<RoomCreationResultEntity> getSuccessResults() {
        return this.successResults;
    }

    @XmlElement(name="result")
    @XmlElementWrapper(name="failure")
    @JsonProperty(value="failure")
    @Schema(description="All creation results of type failure")
    public List<RoomCreationResultEntity> getFailureResults() {
        return this.failureResults;
    }

    @XmlElement(name="result")
    @XmlElementWrapper(name="other")
    @JsonProperty(value="other")
    @Schema(description="All creation results of a type other than success or failure")
    public List<RoomCreationResultEntity> getOtherResults() {
        return this.otherResults;
    }
}

