/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.ClusteringController;
import org.jivesoftware.openfire.plugin.rest.entity.ClusterNodeEntities;
import org.jivesoftware.openfire.plugin.rest.entity.ClusterNodeEntity;
import org.jivesoftware.openfire.plugin.rest.entity.ClusteringEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/clustering")
@Tag(name="Clustering", description="Reporting the status of Openfire clustering")
public class ClusteringService {
    private ClusteringController clusteringController;

    @PostConstruct
    public void init() {
        this.clusteringController = ClusteringController.getInstance();
    }

    @GET
    @Path(value="/status")
    @Operation(summary="Get clustering status", description="Describes the point-in-time state of Openfire's clustering with other servers", responses={@ApiResponse(responseCode="200", description="Status returned", content={@Content(schema=@Schema(implementation=ClusteringEntity.class))})})
    @Produces(value={"application/xml", "application/json"})
    public ClusteringEntity getClusteringStatus() {
        return new ClusteringEntity(this.clusteringController.getClusterStatus());
    }

    @GET
    @Path(value="/nodes")
    @Operation(summary="Get all cluster nodes", description="Get a list of all nodes of the cluster. Note that this endpoint can only return data for remote nodes when the instance of Openfire that processes this query has successfully joined the cluster.", responses={@ApiResponse(responseCode="200", description="Retrieve all cluster nodes", content={@Content(schema=@Schema(implementation=ClusterNodeEntities.class))})})
    @Produces(value={"application/xml", "application/json"})
    public ClusterNodeEntities getClusterNodes() {
        return this.clusteringController.getNodeEntities();
    }

    @GET
    @Path(value="/nodes/{nodeId}")
    @Operation(summary="Get a specific cluster node", description="Get a specific node of the cluster. Note that this endpoint can only return data for remote nodes when the instance of Openfire that processes this query has successfully joined the cluster.", responses={@ApiResponse(responseCode="200", description="Retrieve a cluster node", content={@Content(schema=@Schema(implementation=ClusterNodeEntity.class))}), @ApiResponse(responseCode="404", description="The provided NodeID does not identify an existing cluster node.")})
    @Produces(value={"application/xml", "application/json"})
    public ClusterNodeEntity getClusterNode(@Parameter(description="The nodeID value for a particular node.", example="52a89928-66f7-45fd-9bb8-096de07400ac", required=true) @PathParam(value="nodeId") String nodeId) throws ServiceException {
        Optional<ClusterNodeEntity> entity = this.clusteringController.getNodeEntity(nodeId);
        if (entity.isPresent()) {
            return entity.get();
        }
        throw new ServiceException("Could not find a cluster node with this NodeID.", nodeId, "ClusterNodeNotFoundException", Response.Status.NOT_FOUND);
    }
}

