/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.jaxrs2.integration.resources.BaseOpenApiResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.Collections;
import javax.servlet.ServletConfig;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginMetadataHelper;
import org.jivesoftware.openfire.plugin.rest.RESTServicePlugin;

@Path(value="restapi/v1/")
public class CustomOpenApiResource
extends BaseOpenApiResource {
    @Context
    ServletConfig config;
    @Context
    Application app;

    public CustomOpenApiResource() {
        String key;
        RESTServicePlugin plugin = XMPPServer.getInstance().getPluginManager().getPluginByName("REST API").orElse(null);
        String version = plugin != null ? PluginMetadataHelper.getVersion((Plugin)plugin).getVersionString() : "(unknown)";
        this.openApiConfiguration = new SwaggerConfiguration();
        OpenAPI openAPI = new OpenAPI().servers(Collections.singletonList(new Server().url("/plugins"))).info(new Info().description("This is the documentation for a REST API of the Openfire Real-time communication server.").title("Openfire REST API").contact(new Contact().name("Ignite Realtime Foundation").url("https://www.igniterealtime.org")).version(version).license(new License().name("Apache 2.0").url("http://www.apache.org/licenses/LICENSE-2.0.html")));
        openAPI.components(new Components());
        if (plugin == null || !"basic".equals(plugin.getHttpAuth())) {
            key = "Secret key auth";
            SecurityScheme apiKeyScheme = new SecurityScheme();
            apiKeyScheme.setDescription("Authenticate using the Secret Key as configured in the Openfire admin console.");
            apiKeyScheme.setType(SecurityScheme.Type.APIKEY);
            apiKeyScheme.setName("Authorization");
            apiKeyScheme.setIn(SecurityScheme.In.HEADER);
            openAPI.getComponents().addSecuritySchemes(key, apiKeyScheme);
        } else {
            key = "Admin Console account";
            SecurityScheme basicAuthScheme = new SecurityScheme();
            basicAuthScheme.setDescription("Authenticate using a valid admin account for Openfire admin console.");
            basicAuthScheme.setType(SecurityScheme.Type.HTTP);
            basicAuthScheme.setScheme("basic");
            openAPI.getComponents().addSecuritySchemes(key, basicAuthScheme);
        }
        SecurityRequirement securityItem = new SecurityRequirement();
        securityItem.addList(key);
        openAPI.addSecurityItem(securityItem);
        ((SwaggerConfiguration)this.openApiConfiguration).openAPI(openAPI);
    }

    @GET
    @Path(value="openapi.yaml")
    @Produces(value={"application/yaml"})
    @Operation(hidden=true)
    public Response getOpenApiYaml(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        return super.getOpenApi(headers, this.config, this.app, uriInfo, "yaml");
    }

    @GET
    @Path(value="openapi.json")
    @Produces(value={"application/json"})
    @Operation(hidden=true)
    public Response getOpenApiJson(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        return super.getOpenApi(headers, this.config, this.app, uriInfo, "json");
    }
}

