/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.GroupController;
import org.jivesoftware.openfire.plugin.rest.entity.GroupEntities;
import org.jivesoftware.openfire.plugin.rest.entity.GroupEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/groups")
@Tag(name="User Group", description="Managing Openfire user groupings.")
public class GroupService {
    private GroupController groupController;

    @PostConstruct
    public void init() {
        this.groupController = GroupController.getInstance();
    }

    @GET
    @Operation(summary="Get groups", description="Get a list of all user groups.", responses={@ApiResponse(responseCode="200", description="All groups", content={@Content(schema=@Schema(implementation=GroupEntities.class))})})
    @Produces(value={"application/xml", "application/json"})
    public GroupEntities getGroups() throws ServiceException {
        return new GroupEntities(this.groupController.getGroups());
    }

    @POST
    @Operation(summary="Create group", description="Create a new user group.", responses={@ApiResponse(responseCode="201", description="Group created."), @ApiResponse(responseCode="400", description="Group or group name missing, or invalid syntax for a property."), @ApiResponse(responseCode="409", description="Group already exists.")})
    @Consumes(value={"application/xml", "application/json"})
    public Response createGroup(@RequestBody(description="The group that needs to be created.", required=true) GroupEntity groupEntity) throws ServiceException {
        this.groupController.createGroup(groupEntity);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Path(value="/{groupName}")
    @Operation(summary="Get group", description="Get one specific user group by name.", responses={@ApiResponse(responseCode="200", description="The group.", content={@Content(schema=@Schema(implementation=GroupEntity.class))}), @ApiResponse(responseCode="404", description="Group with this name not found.")})
    @Produces(value={"application/xml", "application/json"})
    public GroupEntity getGroup(@Parameter(description="The name of the group that needs to be fetched.", example="Colleagues", required=true) @PathParam(value="groupName") String groupName) throws ServiceException {
        return this.groupController.getGroup(groupName);
    }

    @PUT
    @Path(value="/{groupName}")
    @Operation(summary="Update group", description="Updates / overwrites an existing user group. Note that the name of the group cannot be changed.", responses={@ApiResponse(responseCode="200", description="Group updated."), @ApiResponse(responseCode="400", description="Group or group name missing, or name does not match existing group, or invalid syntax for a property."), @ApiResponse(responseCode="404", description="Group with this name not found.")})
    @Consumes(value={"application/xml", "application/json"})
    public Response updateGroup(@Parameter(description="The name of the group that needs to be fetched.", example="Colleagues", required=true) @PathParam(value="groupName") String groupName, @RequestBody(description="The new group definition that needs to overwrite the old definition.", required=true) GroupEntity groupEntity) throws ServiceException {
        this.groupController.updateGroup(groupName, groupEntity);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{groupName}")
    @Operation(summary="Delete group", description="Removes an existing user group.", responses={@ApiResponse(responseCode="200", description="Group deleted."), @ApiResponse(responseCode="400", description="Group not found.")})
    public Response deleteGroup(@Parameter(description="The name of the group that needs to be removed.", example="Colleagues", required=true) @PathParam(value="groupName") String groupName) throws ServiceException {
        this.groupController.deleteGroup(groupName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

