/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.server.ResourceConfig;
import org.jivesoftware.openfire.plugin.rest.AuthFilter;
import org.jivesoftware.openfire.plugin.rest.CORSFilter;
import org.jivesoftware.openfire.plugin.rest.CustomJacksonMapperProvider;
import org.jivesoftware.openfire.plugin.rest.StatisticsFilter;
import org.jivesoftware.openfire.plugin.rest.exceptions.RESTExceptionMapper;
import org.jivesoftware.openfire.plugin.rest.service.ClusteringService;
import org.jivesoftware.openfire.plugin.rest.service.CustomOpenApiResource;
import org.jivesoftware.openfire.plugin.rest.service.GroupService;
import org.jivesoftware.openfire.plugin.rest.service.MUCRoomAffiliationsService;
import org.jivesoftware.openfire.plugin.rest.service.MUCRoomService;
import org.jivesoftware.openfire.plugin.rest.service.MUCServiceService;
import org.jivesoftware.openfire.plugin.rest.service.MessageService;
import org.jivesoftware.openfire.plugin.rest.service.MsgArchiveService;
import org.jivesoftware.openfire.plugin.rest.service.SecurityAuditLogService;
import org.jivesoftware.openfire.plugin.rest.service.SessionService;
import org.jivesoftware.openfire.plugin.rest.service.StatisticsService;
import org.jivesoftware.openfire.plugin.rest.service.SystemService;
import org.jivesoftware.openfire.plugin.rest.service.UserGroupService;
import org.jivesoftware.openfire.plugin.rest.service.UserLockoutService;
import org.jivesoftware.openfire.plugin.rest.service.UserRosterService;
import org.jivesoftware.openfire.plugin.rest.service.UserService;
import org.jivesoftware.openfire.plugin.rest.service.UserServiceLegacy;
import org.jivesoftware.util.JiveGlobals;

public class JerseyWrapper
extends ResourceConfig {
    private static final String CUSTOM_AUTH_PROPERTY_NAME = "plugin.restapi.customAuthFilter";
    private static final String REST_AUTH_TYPE = "plugin.restapi.httpAuth";
    public static final String SERVLET_URL = "restapi/*";
    private static final Logger JERSEY_LOGGER = Logger.getLogger("org.glassfish.jersey");
    private static String loadingStatusMessage = null;

    public static String tryLoadingAuthenticationFilter(String customAuthFilterClassName) {
        try {
            if (customAuthFilterClassName != null) {
                Class.forName(customAuthFilterClassName, false, JerseyWrapper.class.getClassLoader());
                loadingStatusMessage = null;
            }
        }
        catch (ClassNotFoundException e) {
            loadingStatusMessage = "No custom auth filter found for restAPI plugin with name " + customAuthFilterClassName;
        }
        if (customAuthFilterClassName == null || customAuthFilterClassName.isEmpty()) {
            loadingStatusMessage = "Classname field can't be empty!";
        }
        return loadingStatusMessage;
    }

    public String loadAuthenticationFilter() {
        String customAuthFilterClassName = JiveGlobals.getProperty((String)CUSTOM_AUTH_PROPERTY_NAME);
        String restAuthType = JiveGlobals.getProperty((String)REST_AUTH_TYPE);
        Class pickedAuthFilter = AuthFilter.class;
        try {
            if (customAuthFilterClassName != null && "custom".equals(restAuthType)) {
                pickedAuthFilter = Class.forName(customAuthFilterClassName, false, JerseyWrapper.class.getClassLoader());
                loadingStatusMessage = null;
            }
        }
        catch (ClassNotFoundException e) {
            loadingStatusMessage = "No custom auth filter found for restAPI plugin! " + customAuthFilterClassName + " " + restAuthType;
        }
        this.register(pickedAuthFilter);
        return loadingStatusMessage;
    }

    public JerseyWrapper(@Context ServletConfig servletConfig) {
        this.loadAuthenticationFilter();
        this.register(CORSFilter.class);
        this.register(StatisticsFilter.class);
        this.registerClasses(new Class[]{ClusteringService.class, GroupService.class, MessageService.class, MsgArchiveService.class, MUCRoomAffiliationsService.class, MUCRoomService.class, MUCServiceService.class, SystemService.class, SecurityAuditLogService.class, SessionService.class, StatisticsService.class, UserGroupService.class, UserLockoutService.class, UserRosterService.class, UserService.class, UserServiceLegacy.class});
        this.register(RESTExceptionMapper.class);
        this.register(CustomJacksonMapperProvider.class);
        this.register((Object)new CustomOpenApiResource());
    }

    public static String getLoadingStatusMessage() {
        return loadingStatusMessage;
    }

    static {
        JERSEY_LOGGER.setLevel(Level.SEVERE);
    }
}

