/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.PostConstruct;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jivesoftware.openfire.plugin.rest.controller.SecurityAuditLogController;
import org.jivesoftware.openfire.plugin.rest.entity.SecurityAuditLogs;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/logs/security")
@Tag(name="Security Audit Log", description="Inspecting the security audit log.")
public class SecurityAuditLogService {
    private SecurityAuditLogController securityAuditLogController;

    @PostConstruct
    public void init() {
        this.securityAuditLogController = SecurityAuditLogController.getInstance();
    }

    @GET
    @Operation(summary="Get log entries", description="Retrieve entries from the security audit log.", responses={@ApiResponse(responseCode="200", description="The requested log entries.", content={@Content(schema=@Schema(implementation=SecurityAuditLogs.class))}), @ApiResponse(responseCode="403", description="The audit log is not readable (configured to be write-only).")})
    @Produces(value={"application/xml", "application/json"})
    public SecurityAuditLogs getSecurityAuditLogs(@Parameter(description="The name of a user for which to filter events.", example="admin", required=false) @QueryParam(value="username") String username, @Parameter(description="Number of log entries to skip.", example="0", required=false) @QueryParam(value="offset") int offset, @Parameter(description="Number of log entries to retrieve.", example="100", required=false) @DefaultValue(value="100") @QueryParam(value="limit") int limit, @Parameter(description="Oldest timestamp of range of logs to retrieve. 0 for 'forever'.", required=false) @QueryParam(value="startTime") long startTime, @Parameter(description="Most recent timestamp of range of logs to retrieve. 0 for 'now'.", required=false) @QueryParam(value="endTime") long endTime) throws ServiceException {
        return this.securityAuditLogController.getSecurityAuditLogs(username, offset, limit, startTime, endTime);
    }
}

