/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.SystemController;
import org.jivesoftware.openfire.plugin.rest.entity.SystemProperties;
import org.jivesoftware.openfire.plugin.rest.entity.SystemProperty;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.spi.ConnectionType;

@Path(value="restapi/v1/system")
@Tag(name="System", description="Managing Openfire system configuration")
public class SystemService {
    @GET
    @Path(value="/properties")
    @Operation(summary="Get system properties", description="Get all Openfire system properties.", responses={@ApiResponse(responseCode="200", description="The system properties.", content={@Content(schema=@Schema(implementation=SystemProperties.class))})})
    @Produces(value={"application/xml", "application/json"})
    public SystemProperties getSystemProperties() {
        return SystemController.getInstance().getSystemProperties();
    }

    @GET
    @Path(value="/properties/{propertyKey}")
    @Operation(summary="Get system property", description="Get a specific Openfire system property.", responses={@ApiResponse(responseCode="200", description="The requested system property.", content={@Content(schema=@Schema(implementation=SystemProperty.class))}), @ApiResponse(responseCode="404", description="The system property could not be found.")})
    @Produces(value={"application/xml", "application/json"})
    public SystemProperty getSystemProperty(@Parameter(description="The name of the system property to return.", example="foo.bar.xyz", required=true) @PathParam(value="propertyKey") String propertyKey) throws ServiceException {
        return SystemController.getInstance().getSystemProperty(propertyKey);
    }

    @POST
    @Path(value="/properties")
    @Operation(summary="Create system property", description="Create a new Openfire system property. Will overwrite a pre-existing system property that uses the same name.", responses={@ApiResponse(responseCode="201", description="The system property is created.")})
    @Consumes(value={"application/xml", "application/json"})
    public Response createSystemProperty(@RequestBody(description="The system property to create.", required=true) SystemProperty systemProperty) throws ServiceException {
        SystemController.getInstance().createSystemProperty(systemProperty);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/properties/{propertyKey}")
    @Operation(summary="Update system property", description="Updates an existing Openfire system property.", responses={@ApiResponse(responseCode="200", description="The system property is updated."), @ApiResponse(responseCode="400", description="The provided system property does not match the name in the URL."), @ApiResponse(responseCode="404", description="The system property could not be found.")})
    @Consumes(value={"application/xml", "application/json"})
    public Response updateSystemProperty(@Parameter(description="The name of the system property to update.", example="foo.bar.xyz", required=true) @PathParam(value="propertyKey") String propertyKey, @RequestBody(description="The new system property definition that replaced an existing definition.", required=true) SystemProperty systemProperty) throws ServiceException {
        SystemController.getInstance().updateSystemProperty(propertyKey, systemProperty);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/properties/{propertyKey}")
    @Operation(summary="Remove system property", description="Removes an existing Openfire system property.", responses={@ApiResponse(responseCode="200", description="The system property is deleted."), @ApiResponse(responseCode="404", description="The system property could not be found.")})
    public Response deleteSystemProperty(@Parameter(description="The name of the system property to delete.", example="foo.bar.xyz", required=true) @PathParam(value="propertyKey") String propertyKey) throws ServiceException {
        SystemController.getInstance().deleteSystemProperty(propertyKey);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/liveness")
    @Operation(summary="Perform all liveness checks", description="Detects if Openfire has reached a state that it cannot recover from, except for with a restart, based on every liveness check that it has implemented.", responses={@ApiResponse(responseCode="200", description="The system is live."), @ApiResponse(responseCode="503", description="At least one liveness check failed: the system is determined to not be alive.")})
    public Response liveness() {
        if (SystemController.getInstance().hasDeadlock()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        if (SystemController.getInstance().hasSystemPropertyRequiringRestart()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/liveness/deadlock")
    @Operation(summary="Perform 'deadlock' liveness check.", description="Detects if Openfire has reached a state that it cannot recover from because of a deadlock.", responses={@ApiResponse(responseCode="200", description="The system is live."), @ApiResponse(responseCode="503", description="A deadlock is detected.")})
    public Response livenessDeadlock() {
        if (SystemController.getInstance().hasDeadlock()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/liveness/properties")
    @Operation(summary="Perform 'properties' liveness check.", description="Detects if Openfire has reached a state that it cannot recover from because a system property change requires a restart to take effect.", responses={@ApiResponse(responseCode="200", description="The system is live."), @ApiResponse(responseCode="503", description="One or more system property changes that require a server restart have been detected.")})
    public Response livenessSystemProperties() {
        if (SystemController.getInstance().hasSystemPropertyRequiringRestart()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/readiness")
    @Operation(summary="Perform all readiness checks", description="Detects if Openfire is in a state where it is ready to process traffic, based on every readiness check that it has implemented.", responses={@ApiResponse(responseCode="200", description="The system is ready."), @ApiResponse(responseCode="503", description="At least one readiness check failed: the system is determined to not be able to process traffic.")})
    public Response readiness() {
        if (!SystemController.getInstance().isStarted()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        if (!SystemController.getInstance().hasClusteringStartedWhenEnabled()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        if (!SystemController.getInstance().hasPluginManagerExecuted()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        if (!SystemController.getInstance().areConnectionListenersStarted()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/readiness/server")
    @Operation(summary="Perform 'server started' readiness check", description="Detects if Openfire's core service has been started.", responses={@ApiResponse(responseCode="200", description="The system is ready."), @ApiResponse(responseCode="503", description="The Openfire service has not finished starting up yet.")})
    public Response readinessServerStart() {
        if (!SystemController.getInstance().isStarted()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/readiness/cluster")
    @Operation(summary="Perform 'cluster' readiness check", description="Detects if the cluster functionality has finished starting (or is disabled).", responses={@ApiResponse(responseCode="200", description="The system is ready."), @ApiResponse(responseCode="503", description="Clustering functionality is enabled, but has not finished starting up yet.")})
    public Response readinessCluster() {
        if (!SystemController.getInstance().hasClusteringStartedWhenEnabled()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/readiness/plugins")
    @Operation(summary="Perform 'plugins' readiness check", description="Detects if Openfire has finished starting its plugins.", responses={@ApiResponse(responseCode="200", description="The system is ready."), @ApiResponse(responseCode="503", description="Plugins have not all been started yet.")})
    public Response readinessPlugins() {
        if (!SystemController.getInstance().hasPluginManagerExecuted()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/readiness/connections")
    @Operation(summary="Perform 'connections' readiness check", description="Detects if Openfire is ready to accept connection requests.", responses={@ApiResponse(responseCode="200", description="The system is ready."), @ApiResponse(responseCode="400", description="The provided connectionType value is invalid."), @ApiResponse(responseCode="503", description="Openfire currently does not accept (all) connections.")})
    public Response readinessConnections(@Parameter(description="Optional. Use to limit the check to one particular connection type. One of: SOCKET_S2S, SOCKET_C2S, BOSH_C2S, WEBADMIN, COMPONENT, CONNECTION_MANAGER", example="SOCKET_C2S", required=false) @QueryParam(value="connectionType") String connectionType, @Parameter(description="Check the encrypted (true) or unencrypted (false) variant of the connection type. Only used in combination with 'connectionType', as without it, all types and both encrypted and unencrypted are checked.", required=false) @QueryParam(value="encrypted") Boolean encrypted) {
        block5: {
            if (connectionType != null && !connectionType.isEmpty()) {
                try {
                    ConnectionType limitToType = ConnectionType.valueOf((String)connectionType);
                    if (!SystemController.getInstance().isConnectionListenerStartedWhenEnabled(limitToType, encrypted)) {
                        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
                    }
                    break block5;
                }
                catch (Throwable t) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            if (!SystemController.getInstance().areConnectionListenersStarted()) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

