/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.UserServiceController;
import org.jivesoftware.openfire.plugin.rest.entity.UserGroupsEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/users/{username}/groups")
@Tag(name="Users", description="Managing Openfire users.")
public class UserGroupService {
    private UserServiceController plugin;

    @PostConstruct
    public void init() {
        this.plugin = UserServiceController.getInstance();
    }

    @GET
    @Operation(summary="Get user's groups", description="Retrieve names of all groups that a particular user is in.", responses={@ApiResponse(responseCode="200", description="The names of the groups that the user is in.", content={@Content(schema=@Schema(implementation=UserGroupsEntity.class))})})
    @Produces(value={"application/xml", "application/json"})
    public UserGroupsEntity getUserGroups(@Parameter(description="The username for user for which to return group names.", required=true) @PathParam(value="username") String username) throws ServiceException {
        return new UserGroupsEntity(this.plugin.getUserGroups(username));
    }

    @POST
    @Operation(summary="Add user to groups", description="Add a particular user to a collection of groups. When a group that is provided does not exist, it will be automatically created if possible.", responses={@ApiResponse(responseCode="201", description="The user was added to all groups."), @ApiResponse(responseCode="400", description="When the username cannot be parsed into a JID.")})
    @Consumes(value={"application/xml", "application/json"})
    public Response addUserToGroups(@Parameter(description="The username of the user that is to be added to groups.", required=true) @PathParam(value="username") String username, @RequestBody(description="A collection of names for groups that the user is to be added to.", required=true) UserGroupsEntity userGroupsEntity) throws ServiceException {
        this.plugin.addUserToGroups(username, userGroupsEntity);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/{groupName}")
    @Operation(summary="Add user to group", description="Add a particular user to a particular group. When the group that does not exist, it will be automatically created if possible.", responses={@ApiResponse(responseCode="201", description="The user was added to the groups."), @ApiResponse(responseCode="400", description="When the username cannot be parsed into a JID.")})
    public Response addUserToGroup(@Parameter(description="The username of the user that is to be added to a group.", required=true) @PathParam(value="username") String username, @Parameter(description="The name of the group that the user is to be added to.", required=true) @PathParam(value="groupName") String groupName) throws ServiceException {
        this.plugin.addUserToGroup(username, groupName);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="/{groupName}")
    @Operation(summary="Delete user from group", description="Removes a user from a group.", responses={@ApiResponse(responseCode="200", description="The user was taken out of the group."), @ApiResponse(responseCode="404", description="The group could not be found.")})
    public Response deleteUserFromGroup(@Parameter(description="The username of the user that is to be removed from a group.", required=true) @PathParam(value="username") String username, @Parameter(description="The name of the group that the user is to be removed from.", required=true) @PathParam(value="groupName") String groupName) throws ServiceException {
        this.plugin.deleteUserFromGroup(username, groupName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Operation(summary="Delete user from groups", description="Removes a user from a collection of groups.", responses={@ApiResponse(responseCode="200", description="The user was taken out of the group."), @ApiResponse(responseCode="404", description="One or more groups could not be found.")})
    @Consumes(value={"application/xml", "application/json"})
    public Response deleteUserFromGroups(@Parameter(description="The username of the user that is to be removed from a group.", required=true) @PathParam(value="username") String username, @RequestBody(description="A collection of names for groups from which the user is to be removed.", required=true) UserGroupsEntity userGroupsEntity) throws ServiceException {
        this.plugin.deleteUserFromGroups(username, userGroupsEntity);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

