/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.UserServiceController;
import org.jivesoftware.openfire.plugin.rest.entity.UserEntities;
import org.jivesoftware.openfire.plugin.rest.entity.UserEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/users")
@Tag(name="Users", description="Managing Openfire users.")
public class UserService {
    private UserServiceController plugin;

    @PostConstruct
    public void init() {
        this.plugin = UserServiceController.getInstance();
    }

    @GET
    @Operation(summary="Get users", description="Retrieve all users defined in Openfire (with optional filtering).", responses={@ApiResponse(responseCode="200", description="A list of Openfire users.", content={@Content(schema=@Schema(implementation=UserEntities.class))})})
    @Produces(value={"application/xml", "application/json"})
    public UserEntities getUsers(@Parameter(description="Search/Filter by username. This act like the wildcard search %String%", required=false) @QueryParam(value="search") String userSearch, @Parameter(description="Filter by a user property name.", required=false) @QueryParam(value="propertyKey") String propertyKey, @Parameter(description="Filter by user property value. Note: This can only be used in combination with a property name parameter", required=false) @QueryParam(value="propertyValue") String propertyValue) throws ServiceException {
        return this.plugin.getUserEntities(userSearch, propertyKey, propertyValue);
    }

    @POST
    @Operation(summary="Create user", description="Add a new user to Openfire.", responses={@ApiResponse(responseCode="201", description="The user was created.")})
    @Consumes(value={"application/xml", "application/json"})
    public Response createUser(@RequestBody(description="The definition of the user to create.", required=true) UserEntity userEntity) throws ServiceException {
        this.plugin.createUser(userEntity);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Path(value="/{username}")
    @Operation(summary="Get user", description="Retrieve a user that is defined in Openfire.", responses={@ApiResponse(responseCode="200", description="A list of Openfire users.", content={@Content(schema=@Schema(implementation=UserEntity.class))}), @ApiResponse(responseCode="404", description="No user with that username was found.")})
    @Produces(value={"application/xml", "application/json"})
    public UserEntity getUser(@Parameter(description="The username of the user to return.", required=true) @PathParam(value="username") String username) throws ServiceException {
        return this.plugin.getUserEntity(username);
    }

    @PUT
    @Path(value="/{username}")
    @Operation(summary="Update user", description="Update an existing user in Openfire.", responses={@ApiResponse(responseCode="200", description="The user was updated.")})
    public Response updateUser(@Parameter(description="The username of the user to update.", required=true) @PathParam(value="username") String username, @RequestBody(description="The definition update of the user.", required=true) UserEntity userEntity) throws ServiceException {
        this.plugin.updateUser(username, userEntity);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{username}")
    @Operation(summary="Delete user", description="Remove an existing user from Openfire.", responses={@ApiResponse(responseCode="200", description="The user was removed."), @ApiResponse(responseCode="404", description="No user with that username was found.")})
    public Response deleteUser(@Parameter(description="The username of the user to remove.", required=true) @PathParam(value="username") String username) throws ServiceException {
        this.plugin.deleteUser(username);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

