/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.container.PluginMetadataHelper;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.ComponentManagerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.resultsetmanagement.ResultSet;
import org.xmpp.resultsetmanagement.ResultSetImpl;

public class SearchPlugin
implements Component,
Plugin,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(SearchPlugin.class);
    public static final String NAMESPACE_JABBER_IQ_SEARCH = "jabber:iq:search";
    public static final String SERVICENAME = "plugin.search.serviceName";
    public static final String SERVICEENABLED = "plugin.search.serviceEnabled";
    public static final String EXCLUDEDFIELDS = "plugin.search.excludedFields";
    public static final String GROUPONLY = "plugin.search.groupOnly";
    private UserManager userManager;
    private ComponentManager componentManager;
    private PluginManager pluginManager;
    private String serviceName;
    private boolean serviceEnabled;
    private Collection<String> excludedFields;
    private boolean groupOnly;
    private static String serverName;
    private TreeMap<String, String> fieldLookup = new TreeMap(new CaseInsensitiveComparator());
    private Map<String, String> reverseFieldLookup = new HashMap<String, String>();
    public static final Collection<String> validSearchRequestFields;

    public SearchPlugin() {
        this.serviceName = JiveGlobals.getProperty((String)SERVICENAME, (String)"search");
        this.serviceEnabled = JiveGlobals.getBooleanProperty((String)SERVICEENABLED, (boolean)true);
        this.excludedFields = StringUtils.stringToCollection((String)JiveGlobals.getProperty((String)EXCLUDEDFIELDS, (String)""));
        this.groupOnly = JiveGlobals.getBooleanProperty((String)GROUPONLY);
        serverName = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
        this.userManager = UserManager.getInstance();
        this.fieldLookup.put("jid", "Username");
        this.fieldLookup.put("username", "Username");
        this.fieldLookup.put("first", "Name");
        this.fieldLookup.put("last", "Name");
        this.fieldLookup.put("nick", "Name");
        this.fieldLookup.put("name", "Name");
        this.fieldLookup.put("email", "Email");
    }

    public String getName() {
        return PluginMetadataHelper.getName((Plugin)this);
    }

    public String getDescription() {
        return PluginMetadataHelper.getDescription((Plugin)this);
    }

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        this.pluginManager = manager;
        this.componentManager = ComponentManagerFactory.getComponentManager();
        try {
            this.componentManager.addComponent(this.serviceName, (Component)this);
        }
        catch (ComponentException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        PropertyEventDispatcher.addListener((PropertyEventListener)this);
    }

    public void initialize(JID jid, ComponentManager componentManager) {
    }

    public void start() {
    }

    public void destroyPlugin() {
        block2: {
            PropertyEventDispatcher.removeListener((PropertyEventListener)this);
            this.pluginManager = null;
            try {
                this.componentManager.removeComponent(this.serviceName);
                this.componentManager = null;
            }
            catch (Exception e) {
                if (this.componentManager == null) break block2;
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.serviceName = null;
        this.userManager = null;
        this.excludedFields = null;
        serverName = null;
        this.fieldLookup = null;
        this.reverseFieldLookup = null;
    }

    public void shutdown() {
    }

    public void processPacket(Packet p) {
        if (!(p instanceof IQ)) {
            return;
        }
        IQ packet = (IQ)p;
        if (packet.getType().equals((Object)IQ.Type.error) || packet.getType().equals((Object)IQ.Type.result)) {
            return;
        }
        IQ replyPacket = this.handleIQRequest(packet);
        try {
            this.componentManager.sendPacket((Component)this, (Packet)replyPacket);
        }
        catch (ComponentException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    private IQ handleIQRequest(IQ iq) {
        IQ replyPacket;
        if (iq == null) {
            throw new IllegalArgumentException("Argument 'iq' cannot be null.");
        }
        IQ.Type type = iq.getType();
        if (type != IQ.Type.get && type != IQ.Type.set) {
            throw new IllegalArgumentException("Argument 'iq' must be of type 'get' or 'set'");
        }
        Element childElement = iq.getChildElement();
        if (childElement == null) {
            IQ replyPacket2 = IQ.createResultIQ((IQ)iq);
            replyPacket2.setError(new PacketError(PacketError.Condition.bad_request, PacketError.Type.modify, "IQ stanzas of type 'get' and 'set' MUST contain one and only one child element (RFC 3920 section 9.2.3)."));
            return replyPacket2;
        }
        String namespace = childElement.getNamespaceURI();
        if (namespace == null) {
            IQ replyPacket3 = IQ.createResultIQ((IQ)iq);
            replyPacket3.setError(PacketError.Condition.feature_not_implemented);
            return replyPacket3;
        }
        if (namespace.equals(NAMESPACE_JABBER_IQ_SEARCH)) {
            replyPacket = this.handleSearchRequest(iq);
        } else if (namespace.equals("http://jabber.org/protocol/disco#info")) {
            replyPacket = SearchPlugin.handleDiscoInfo(iq);
        } else if (namespace.equals("http://jabber.org/protocol/disco#items")) {
            replyPacket = IQ.createResultIQ((IQ)iq);
            replyPacket.setChildElement("query", "http://jabber.org/protocol/disco#items");
        } else {
            replyPacket = IQ.createResultIQ((IQ)iq);
            replyPacket.setError(PacketError.Condition.feature_not_implemented);
        }
        return replyPacket;
    }

    private static IQ handleDiscoInfo(IQ iq) {
        if (iq == null) {
            throw new IllegalArgumentException("Argument 'iq' cannot be null.");
        }
        if (!iq.getChildElement().getNamespaceURI().equals("http://jabber.org/protocol/disco#info") || iq.getType() != IQ.Type.get) {
            throw new IllegalArgumentException("This is not a valid disco#info request.");
        }
        IQ replyPacket = IQ.createResultIQ((IQ)iq);
        Element responseElement = replyPacket.setChildElement("query", "http://jabber.org/protocol/disco#info");
        responseElement.addElement("identity").addAttribute("category", "directory").addAttribute("type", "user").addAttribute("name", "User Search");
        responseElement.addElement("feature").addAttribute("var", NAMESPACE_JABBER_IQ_SEARCH);
        responseElement.addElement("feature").addAttribute("var", "http://jabber.org/protocol/disco#info");
        responseElement.addElement("feature").addAttribute("var", "http://jabber.org/protocol/rsm");
        return replyPacket;
    }

    private IQ handleSearchRequest(IQ packet) {
        if (!this.serviceEnabled) {
            return SearchPlugin.replyDisabled(packet);
        }
        switch (packet.getType()) {
            case get: {
                return this.processGetPacket(packet);
            }
            case set: {
                return this.processSetPacket(packet);
            }
        }
        return null;
    }

    private static IQ replyDisabled(IQ packet) {
        IQ replyPacket = IQ.createResultIQ((IQ)packet);
        Element reply = replyPacket.setChildElement("query", NAMESPACE_JABBER_IQ_SEARCH);
        DataForm unavailableForm = new DataForm(DataForm.Type.cancel);
        unavailableForm.setTitle(LocaleUtils.getLocalizedString((String)"advance.user.search.title", (String)"search"));
        unavailableForm.addInstruction(LocaleUtils.getLocalizedString((String)"search.service_unavailable", (String)"search"));
        reply.add(unavailableForm.getElement());
        return replyPacket;
    }

    private IQ processGetPacket(IQ packet) {
        if (!packet.getType().equals((Object)IQ.Type.get)) {
            throw new IllegalArgumentException("This method only accepts 'get' typed IQ stanzas as an argument.");
        }
        IQ replyPacket = IQ.createResultIQ((IQ)packet);
        Element queryResult = DocumentHelper.createElement((QName)QName.get((String)"query", (String)NAMESPACE_JABBER_IQ_SEARCH));
        String instructions = LocaleUtils.getLocalizedString((String)"advance.user.search.details", (String)"search");
        queryResult.addElement("instructions").addText(instructions);
        queryResult.addElement("first");
        queryResult.addElement("last");
        queryResult.addElement("nick");
        queryResult.addElement("email");
        DataForm searchForm = new DataForm(DataForm.Type.form);
        searchForm.setTitle(LocaleUtils.getLocalizedString((String)"advance.user.search.title", (String)"search"));
        searchForm.addInstruction(instructions);
        searchForm.addField("FORM_TYPE", null, FormField.Type.hidden).addValue((Object)NAMESPACE_JABBER_IQ_SEARCH);
        searchForm.addField("search", LocaleUtils.getLocalizedString((String)"advance.user.search.search", (String)"search"), FormField.Type.text_single).setRequired(true);
        for (String searchField : this.getFilteredSearchFields()) {
            FormField field = searchForm.addField();
            field.setVariable(searchField);
            field.setType(FormField.Type.boolean_type);
            field.addValue((Object)"1");
            field.setLabel(LocaleUtils.getLocalizedString((String)("advance.user.search." + searchField.toLowerCase()), (String)"search"));
            field.setRequired(false);
        }
        queryResult.add(searchForm.getElement());
        replyPacket.setChildElement(queryResult);
        return replyPacket;
    }

    private IQ processSetPacket(IQ packet) {
        IQ resultIQ;
        if (!packet.getType().equals((Object)IQ.Type.set)) {
            throw new IllegalArgumentException("This method only accepts 'set' typed IQ stanzas as an argument.");
        }
        JID fromJID = packet.getFrom();
        if (!SearchPlugin.isValidSearchRequest(packet)) {
            IQ resultIQ2 = IQ.createResultIQ((IQ)packet);
            resultIQ2.setError(PacketError.Condition.bad_request);
            return resultIQ2;
        }
        Element incomingForm = packet.getChildElement();
        boolean isDataFormQuery = incomingForm.element(QName.get((String)"x", (String)"jabber:x:data")) != null;
        Element rsmElement = incomingForm.element(QName.get((String)"set", (String)"http://jabber.org/protocol/rsm"));
        if (rsmElement != null) {
            List rsmResults;
            Element maxElement = rsmElement.element("max");
            Element startIndexElement = rsmElement.element("index");
            int startIndex = 0;
            if (startIndexElement != null) {
                startIndex = Integer.parseInt(startIndexElement.getTextTrim());
            }
            int max = -1;
            if (maxElement != null) {
                max = Integer.parseInt(maxElement.getTextTrim());
            }
            Set<User> searchResults = this.performSearch(incomingForm, startIndex, max);
            if (this.groupOnly) {
                Collection groups = GroupManager.getInstance().getGroups(fromJID);
                HashSet<User> allSearchResults = new HashSet<User>(searchResults);
                searchResults.clear();
                for (User user : allSearchResults) {
                    for (Group group : groups) {
                        if (!group.isUser(user.getUID())) continue;
                        searchResults.add(user);
                    }
                }
            }
            ResultSetImpl rs = new ResultSetImpl(searchResults);
            try {
                rsmResults = rs.applyRSMDirectives(rsmElement);
            }
            catch (NullPointerException e) {
                IQ itemNotFound = IQ.createResultIQ((IQ)packet);
                itemNotFound.setError(PacketError.Condition.item_not_found);
                return itemNotFound;
            }
            resultIQ = isDataFormQuery ? this.replyDataFormResult(rsmResults, packet) : this.replyNonDataFormResult(rsmResults, packet);
            Element set = rs.generateSetElementFromResults(rsmResults);
            resultIQ.getChildElement().add(set);
        } else {
            Set<User> searchResults = this.performSearch(incomingForm);
            if (this.groupOnly) {
                Collection groups = GroupManager.getInstance().getGroups(fromJID);
                HashSet<User> allSearchResults = new HashSet<User>(searchResults);
                searchResults.clear();
                for (User user : allSearchResults) {
                    for (Group group : groups) {
                        if (!group.isUser(user.getUID())) continue;
                        searchResults.add(user);
                    }
                }
            }
            resultIQ = isDataFormQuery ? this.replyDataFormResult(searchResults, packet) : this.replyNonDataFormResult(searchResults, packet);
        }
        return resultIQ;
    }

    public Set<User> filterGroupSearchResults(JID jid, Set<User> searchResults) {
        if (this.groupOnly) {
            Collection groups = GroupManager.getInstance().getGroups(jid);
            HashSet<User> allSearchResults = new HashSet<User>(searchResults);
            searchResults.clear();
            for (User user : allSearchResults) {
                for (Group group : groups) {
                    if (!group.isUser(user.getUID())) continue;
                    searchResults.add(user);
                }
            }
        }
        return searchResults;
    }

    public static boolean isValidSearchRequest(IQ iq) {
        if (iq == null) {
            throw new IllegalArgumentException("Argument 'iq' cannot be null.");
        }
        if (iq.getType() != IQ.Type.set) {
            return false;
        }
        Element childElement = iq.getChildElement();
        if (childElement == null) {
            return false;
        }
        if (!childElement.getNamespaceURI().equals(NAMESPACE_JABBER_IQ_SEARCH)) {
            return false;
        }
        if (!childElement.getName().equals("query")) {
            return false;
        }
        List fields = childElement.elements();
        if (fields.size() == 0) {
            return false;
        }
        for (Element element : fields) {
            String name = element.getName();
            if (!validSearchRequestFields.contains(name)) {
                return false;
            }
            if (!name.equals("set") || ResultSet.isValidRSMRequest((Element)element)) continue;
            return false;
        }
        return true;
    }

    private Set<User> performSearch(Element incomingForm, int startIndex, int max) {
        HashSet<User> users = new HashSet<User>();
        Hashtable<String, String> searchList = this.extractSearchQuery(incomingForm);
        for (Map.Entry<String, String> entry : searchList.entrySet()) {
            String field = entry.getKey();
            String query = entry.getValue();
            ArrayList foundUsers = new ArrayList();
            if (this.userManager != null && query.length() > 0 && !query.equals(NAMESPACE_JABBER_IQ_SEARCH)) {
                if (max >= 0) {
                    foundUsers.addAll(this.userManager.findUsers(new HashSet<String>(Arrays.asList(field)), query, startIndex, max));
                } else {
                    foundUsers.addAll(this.userManager.findUsers(new HashSet<String>(Arrays.asList(field)), query));
                }
            }
            for (User user : foundUsers) {
                if (user == null) continue;
                users.add(user);
            }
        }
        return users;
    }

    private Set<User> performSearch(Element incomingForm) {
        return this.performSearch(incomingForm, -1, -1);
    }

    private Hashtable<String, String> extractSearchQuery(Element incomingForm) {
        if (incomingForm.element(QName.get((String)"x", (String)"jabber:x:data")) != null) {
            return this.extractExtendedSearchQuery(incomingForm);
        }
        Hashtable<String, String> searchList = new Hashtable<String, String>();
        Iterator iter = incomingForm.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            String name = element.getName();
            if (!this.fieldLookup.containsKey(name)) continue;
            this.reverseFieldLookup.put(this.fieldLookup.get(name), name);
            searchList.put(this.fieldLookup.get(name), element.getText());
        }
        return searchList;
    }

    private Hashtable<String, String> extractExtendedSearchQuery(Element incomingForm) {
        Element dataform = incomingForm.element(QName.get((String)"x", (String)"jabber:x:data"));
        Hashtable<String, String> searchList = new Hashtable<String, String>();
        ArrayList<String> searchFields = new ArrayList<String>();
        String search = "";
        Iterator fields = dataform.elementIterator("field");
        while (fields.hasNext()) {
            Element searchField = (Element)fields.next();
            String field = searchField.attributeValue("var");
            String value = "";
            if (searchField.element("value") != null) {
                value = searchField.element("value").getTextTrim();
            }
            if (field.equals("search")) {
                search = value;
                continue;
            }
            if (!SearchPlugin.isTruthy(value)) continue;
            searchFields.add(field);
        }
        for (String field : searchFields) {
            searchList.put(field, search);
        }
        return searchList;
    }

    private static boolean isTruthy(String value) {
        return "1".equals(value) || Boolean.parseBoolean(value);
    }

    private IQ replyDataFormResult(Collection<User> users, IQ packet) {
        DataForm searchResults = new DataForm(DataForm.Type.result);
        searchResults.addField("FORM_TYPE", null, FormField.Type.hidden);
        searchResults.addReportedField("jid", "JID", FormField.Type.jid_single);
        for (String fieldName : this.getFilteredSearchFields()) {
            searchResults.addReportedField(fieldName, LocaleUtils.getLocalizedString((String)("advance.user.search." + fieldName.toLowerCase()), (String)"search"), FormField.Type.text_single);
        }
        for (User user : users) {
            String username = JID.unescapeNode((String)user.getUsername());
            LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
            item.put("jid", username + "@" + serverName);
            item.put(LocaleUtils.getLocalizedString((String)"advance.user.search.username", (String)"search"), username);
            item.put(LocaleUtils.getLocalizedString((String)"advance.user.search.name", (String)"search"), user.isNameVisible() ? this.removeNull(user.getName()) : "");
            item.put(LocaleUtils.getLocalizedString((String)"advance.user.search.email", (String)"search"), user.isEmailVisible() ? this.removeNull(user.getEmail()) : "");
            searchResults.addItemFields(item);
        }
        IQ replyPacket = IQ.createResultIQ((IQ)packet);
        Element reply = replyPacket.setChildElement("query", NAMESPACE_JABBER_IQ_SEARCH);
        reply.add(searchResults.getElement());
        return replyPacket;
    }

    private IQ replyNonDataFormResult(Collection<User> users, IQ packet) {
        IQ replyPacket = IQ.createResultIQ((IQ)packet);
        Element replyQuery = replyPacket.setChildElement("query", NAMESPACE_JABBER_IQ_SEARCH);
        for (User user : users) {
            Element item = replyQuery.addElement("item");
            String username = JID.unescapeNode((String)user.getUsername());
            item.addAttribute("jid", username + "@" + serverName);
            for (String field : this.reverseFieldLookup.keySet()) {
                Element element;
                if ("Username".equals(field)) {
                    element = item.addElement(this.reverseFieldLookup.get(field));
                    element.addText(username);
                }
                if ("Name".equals(field)) {
                    element = item.addElement(this.reverseFieldLookup.get(field));
                    element.addText(user.isNameVisible() ? this.removeNull(user.getName()) : "");
                }
                if (!"Email".equals(field)) continue;
                element = item.addElement(this.reverseFieldLookup.get(field));
                element.addText(user.isEmailVisible() ? this.removeNull(user.getEmail()) : "");
            }
        }
        return replyPacket;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.changeServiceName(name);
        JiveGlobals.setProperty((String)SERVICENAME, (String)name);
    }

    public boolean getServiceEnabled() {
        return this.serviceEnabled;
    }

    public void setServiceEnabled(boolean enabled) {
        this.serviceEnabled = enabled;
        JiveGlobals.setProperty((String)SERVICEENABLED, (String)(enabled ? "true" : "false"));
    }

    public Collection<String> getFilteredSearchFields() {
        Collection<String> searchFields;
        try {
            searchFields = new ArrayList<String>(this.userManager.getSearchFields());
        }
        catch (UnsupportedOperationException uoe) {
            searchFields = this.getSearchPluginUserManagerSearchFields();
        }
        searchFields.removeAll(this.excludedFields);
        return searchFields;
    }

    public void setExcludedFields(Collection<String> excludedFields) {
        this.excludedFields = excludedFields;
        JiveGlobals.setProperty((String)EXCLUDEDFIELDS, (String)StringUtils.collectionToString(excludedFields));
    }

    public boolean isGroupOnly() {
        return this.groupOnly;
    }

    public void setGroupOnly(boolean groupOnly) {
        this.groupOnly = groupOnly;
        JiveGlobals.setProperty((String)GROUPONLY, (String)(groupOnly ? "true" : "false"));
    }

    public void propertySet(String property, Map<String, Object> params) {
        if (property.equals(SERVICEENABLED)) {
            this.serviceEnabled = Boolean.parseBoolean((String)params.get("value"));
        } else if (property.equals(SERVICENAME)) {
            this.changeServiceName((String)params.get("value"));
        } else if (property.equals(EXCLUDEDFIELDS)) {
            this.excludedFields = StringUtils.stringToCollection((String)JiveGlobals.getProperty((String)EXCLUDEDFIELDS, (String)((String)params.get("value"))));
        } else if (property.equals(GROUPONLY)) {
            this.groupOnly = Boolean.parseBoolean((String)params.get("value"));
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
        if (property.equals(SERVICEENABLED)) {
            this.serviceEnabled = true;
        } else if (property.equals(SERVICENAME)) {
            this.changeServiceName("search");
        } else if (property.equals(EXCLUDEDFIELDS)) {
            this.excludedFields = new ArrayList<String>();
        } else if (property.equals(GROUPONLY)) {
            this.groupOnly = false;
        }
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }

    private void changeServiceName(String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("Service name cannot be null");
        }
        if (this.serviceName.equals(serviceName)) {
            return;
        }
        try {
            this.componentManager.removeComponent(this.serviceName);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.componentManager.addComponent(serviceName, (Component)this);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        this.serviceName = serviceName;
    }

    private String removeNull(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public Collection<String> getSearchPluginUserManagerSearchFields() {
        return Arrays.asList("Username", "Name", "Email");
    }

    static {
        validSearchRequestFields = new ArrayList<String>();
        validSearchRequestFields.add("first");
        validSearchRequestFields.add("last");
        validSearchRequestFields.add("nick");
        validSearchRequestFields.add("email");
        validSearchRequestFields.add("x");
        validSearchRequestFields.add("set");
    }

    private class CaseInsensitiveComparator
    implements Comparator<String> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareToIgnoreCase(s2);
        }
    }
}

