/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.javax.sip.header.HeaderFactoryExt;
import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.message.Content;
import gov.nist.javax.sip.message.ContentImpl;
import gov.nist.javax.sip.message.MultipartMimeContent;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.sip.header.ContentDispositionHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;

public class MultipartMimeContentImpl
implements MultipartMimeContent {
    public static final String BOUNDARY = "boundary";
    private List<Content> contentList = new LinkedList<Content>();
    private HeaderFactoryExt headerFactory = new HeaderFactoryImpl();
    private ContentTypeHeader multipartMimeContentTypeHeader;
    private String boundary;

    public MultipartMimeContentImpl(ContentTypeHeader contentTypeHeader) {
        this.multipartMimeContentTypeHeader = contentTypeHeader;
        this.boundary = contentTypeHeader.getParameter(BOUNDARY);
    }

    @Override
    public boolean add(Content content) {
        return this.contentList.add((ContentImpl)content);
    }

    @Override
    public ContentTypeHeader getContentTypeHeader() {
        return this.multipartMimeContentTypeHeader;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Content content : this.contentList) {
            result.append("--" + this.boundary + "\r\n");
            result.append(content.toString());
            result.append("\r\n");
        }
        if (!this.contentList.isEmpty()) {
            result.append("--" + this.boundary + "--");
        }
        return result.toString();
    }

    public void createContentList(String body) throws ParseException {
        if (this.boundary != null) {
            Scanner scanner = new Scanner(body);
            scanner.useDelimiter("\r?\n?--" + this.boundary + "(--)?\r?\n?");
            while (scanner.hasNext()) {
                try {
                    String bodyPart = scanner.next();
                    ContentImpl partContent = this.parseBodyPart(bodyPart);
                    this.contentList.add(partContent);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        } else {
            ContentImpl content = this.parseBodyPart(body);
            content.setContentTypeHeader(this.getContentTypeHeader());
            this.contentList.add(content);
        }
    }

    private ContentImpl parseBodyPart(String bodyPart) throws ParseException {
        String bodyContent;
        String[] headers = null;
        if (bodyPart.startsWith("\n") || bodyPart.startsWith("\r\n")) {
            bodyContent = bodyPart;
        } else {
            String[] potentialHeaders;
            String[] nextPartSplit = bodyPart.split("\r?\n\r?\n", 2);
            bodyContent = bodyPart;
            if (nextPartSplit.length == 2 && (potentialHeaders = nextPartSplit[0].split("\r?\n"))[0].indexOf(":") > 0) {
                headers = potentialHeaders;
                bodyContent = nextPartSplit[1];
            }
        }
        ContentImpl content = new ContentImpl(bodyContent);
        if (headers != null) {
            for (void var8_8 : headers) {
                Header header = this.headerFactory.createHeader((String)var8_8);
                if (header instanceof ContentTypeHeader) {
                    content.setContentTypeHeader((ContentTypeHeader)header);
                    continue;
                }
                if (header instanceof ContentDispositionHeader) {
                    content.setContentDispositionHeader((ContentDispositionHeader)header);
                    continue;
                }
                content.addExtensionHeader(header);
            }
        }
        return content;
    }

    @Override
    public void addContent(Content content) {
        this.add(content);
    }

    @Override
    public Iterator<Content> getContents() {
        return this.contentList.iterator();
    }

    @Override
    public int getContentCount() {
        return this.contentList.size();
    }
}

