/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip;

import java.io.File;
import java.util.Map;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.sip.log.LogComponent;
import org.jivesoftware.openfire.sip.log.LogListenerImpl;
import org.jivesoftware.openfire.sip.sipaccount.SipComponent;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.ComponentManagerFactory;

public class SipManager
implements Plugin,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(SipManager.class);
    private String serviceName = JiveGlobals.getProperty((String)"plugin.sipark.serviceName", (String)"sipark");
    private ComponentManager componentManager;
    private SipComponent sipComponent;
    private LogComponent logComponent;

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        this.componentManager = ComponentManagerFactory.getComponentManager();
        this.sipComponent = new SipComponent();
        LogListenerImpl logListener = new LogListenerImpl(this.componentManager);
        this.logComponent = new LogComponent(logListener);
        try {
            this.componentManager.addComponent(this.serviceName, (Component)this.sipComponent);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.componentManager.addComponent("logger", (Component)this.logComponent);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        PropertyEventDispatcher.addListener((PropertyEventListener)this);
        Log.debug("SIPARK STARTED");
    }

    public void destroyPlugin() {
        PropertyEventDispatcher.removeListener((PropertyEventListener)this);
        if (this.componentManager != null) {
            try {
                this.componentManager.removeComponent(this.serviceName);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
            try {
                this.componentManager.removeComponent("logger");
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.sipComponent = null;
        this.logComponent = null;
        this.componentManager = null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        JiveGlobals.setProperty((String)"plugin.sipark.serviceName", (String)serviceName);
    }

    private void changeServiceName(String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("Service name cannot be null");
        }
        if (this.serviceName.equals(serviceName)) {
            return;
        }
        try {
            this.componentManager.removeComponent(this.serviceName);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.componentManager.addComponent(serviceName, (Component)this.sipComponent);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        this.serviceName = serviceName;
    }

    public void propertySet(String property, Map params) {
        if (property.equals("http://www.jivesoftware.com/protocol/sipark")) {
            this.changeServiceName((String)params.get("value"));
        }
    }

    public void propertyDeleted(String property, Map params) {
        if (property.equals(this.serviceName)) {
            this.changeServiceName("sipark");
        }
    }

    public void xmlPropertySet(String property, Map params) {
    }

    public void xmlPropertyDeleted(String property, Map params) {
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }
}

