/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.log;

import org.dom4j.Element;
import org.jivesoftware.openfire.sip.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentManager;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class LogComponent
implements Component {
    private static final Logger Log = LoggerFactory.getLogger(LogComponent.class);
    ComponentManager componentManager = null;
    private LogListener logListener = null;
    public static final String NAMESPACE = "http://www.jivesoftware.com/protocol/log";
    public static final String PROPNAME = "plugin.logger.serviceName";
    public static final String NAME = "logger";

    public LogComponent(LogListener logListener) {
        this.componentManager = logListener.getComponentManager();
        this.logListener = logListener;
    }

    public void initialize(JID jid, ComponentManager componentManager) {
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void processPacket(Packet packet) {
        if (packet instanceof IQ) {
            IQ iq = (IQ)packet;
            if (IQ.Type.error == iq.getType() || IQ.Type.result == iq.getType()) {
                return;
            }
            this.processIQ(iq);
        }
    }

    private void processIQ(IQ iq) {
        IQ reply = IQ.createResultIQ((IQ)iq);
        Element childElement = iq.getChildElement();
        String namespace = childElement.getNamespaceURI();
        Element childElementCopy = iq.getChildElement().createCopy();
        reply.setChildElement(childElementCopy);
        if ("http://jabber.org/protocol/disco#info".equals(namespace)) {
            if (iq.getTo().getNode() == null) {
                Element identity = childElementCopy.addElement("identity");
                identity.addAttribute("category", "component");
                identity.addAttribute("type", "generic");
                identity.addAttribute("name", "Remote Logger");
                childElementCopy.addElement("feature").addAttribute("var", "http://jabber.org/protocol/disco#info");
                childElementCopy.addElement("feature").addAttribute("var", NAMESPACE);
            }
        } else if (NAMESPACE.equals(namespace)) {
            if (iq.getTo().getNode() == null && iq.getFrom() != null) {
                reply = this.logListener.logReceived(reply);
            } else {
                reply.getChildElement().addAttribute("type", "unregistered");
            }
        }
        try {
            this.componentManager.sendPacket((Component)this, (Packet)reply);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getDescription() {
        return "Remote Logger";
    }

    public String getName() {
        return NAME;
    }
}

