/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.log;

import java.sql.SQLException;
import java.util.Date;
import org.dom4j.Element;
import org.jivesoftware.openfire.sip.calllog.CallLog;
import org.jivesoftware.openfire.sip.calllog.CallLogDAO;
import org.jivesoftware.openfire.sip.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.ComponentManager;
import org.xmpp.packet.IQ;

public class LogListenerImpl
implements LogListener {
    private static final Logger Log = LoggerFactory.getLogger(LogListenerImpl.class);
    ComponentManager componentManager = null;

    public LogListenerImpl(ComponentManager componentmanager) {
        this.componentManager = componentmanager;
    }

    @Override
    public IQ logReceived(IQ iq) {
        String username = iq.getTo().toBareJID().split("@")[0];
        if (username != null) {
            CallLog callLog = new CallLog(username);
            Element pe = iq.getChildElement().element("callLog");
            if (pe != null) {
                Element numA = pe.element("numA");
                Element numB = pe.element("numB");
                Element duration = pe.element("duration");
                Element type = pe.element("type");
                callLog.setNumA(numA != null ? numA.getTextTrim() : "");
                callLog.setNumB(numB != null ? numB.getTextTrim() : "");
                callLog.setDateTime(new Date().getTime());
                callLog.setDuration(duration != null ? Integer.parseInt(duration.getText()) : 0);
                if (type != null && "loss".equals(type.getTextTrim())) {
                    type.setText("missed");
                }
                callLog.setType(type != null ? CallLog.Type.valueOf(type.getTextTrim()) : CallLog.Type.dialed);
                try {
                    CallLogDAO.insert(callLog);
                }
                catch (SQLException e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        iq.setType(IQ.Type.result);
        iq.deleteExtension("callLog", "http://www.jivesoftware.com/protocol/sipark/log");
        Element childElement = iq.getChildElement();
        if (childElement != null) {
            Element childElementCopy = childElement.createCopy();
            iq.setChildElement(childElementCopy);
        }
        return iq;
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }
}

