/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.sipaccount;

import java.sql.SQLException;
import org.dom4j.Element;
import org.jivesoftware.openfire.event.SessionEventDispatcher;
import org.jivesoftware.openfire.event.SessionEventListener;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.openfire.sip.sipaccount.SipAccount;
import org.jivesoftware.openfire.sip.sipaccount.SipAccountDAO;
import org.jivesoftware.openfire.sip.sipaccount.SipRegisterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.ComponentManagerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public class SipComponent
implements Component,
SessionEventListener {
    private static final Logger Log = LoggerFactory.getLogger(SipComponent.class);
    ComponentManager componentManager = ComponentManagerFactory.getComponentManager();
    public static final String NAMESPACE = "http://www.jivesoftware.com/protocol/sipark";
    public static final String PROPNAME = "plugin.sipark.serviceName";
    public static final String NAME = "sipark";

    public SipComponent() {
        SessionEventDispatcher.addListener((SessionEventListener)this);
    }

    public void initialize(JID jid, ComponentManager componentManager) {
    }

    public void start() {
    }

    public void shutdown() {
        SessionEventDispatcher.removeListener((SessionEventListener)this);
    }

    public void processPacket(Packet packet) {
        Log.debug(packet.toXML());
        if (packet instanceof IQ) {
            IQ iq = (IQ)packet;
            if (IQ.Type.error == iq.getType() || IQ.Type.result == iq.getType()) {
                return;
            }
            this.processIQ(iq);
        }
    }

    private void processIQ(IQ iq) {
        IQ reply = IQ.createResultIQ((IQ)iq);
        String namespace = iq.getChildElement().getNamespaceURI();
        Element childElement = iq.getChildElement().createCopy();
        reply.setChildElement(childElement);
        if ("http://jabber.org/protocol/disco#info".equals(namespace)) {
            if (iq.getTo().getNode() == null) {
                Element identity = childElement.addElement("identity");
                identity.addAttribute("category", "component");
                identity.addAttribute("type", "generic");
                identity.addAttribute("name", "SIP Controller");
                childElement.addElement("feature").addAttribute("var", "http://jabber.org/protocol/disco#info");
                childElement.addElement("feature").addAttribute("var", NAMESPACE);
            }
        } else if (NAMESPACE.equals(namespace)) {
            if (iq.getTo().getNode() == null && iq.getFrom() != null) {
                Element status;
                SipAccount sipAccount = SipAccountDAO.getAccountByUser(iq.getFrom().toBareJID().split("@")[0]);
                if (iq.getChildElement().element("status") == null) {
                    if (sipAccount != null && sipAccount.isEnabled()) {
                        Element registration = childElement.addElement("registration");
                        registration.addElement("jid").setText(sipAccount.getUsername() + "@" + this.componentManager.getServerName());
                        registration.addElement("username").setText(sipAccount.getSipUsername());
                        registration.addElement("authUsername").setText(sipAccount.getAuthUsername());
                        registration.addElement("displayPhoneNum").setText(sipAccount.getDisplayName());
                        registration.addElement("password").setText(sipAccount.getPassword());
                        registration.addElement("server").setText(sipAccount.getServer());
                        registration.addElement("stunServer").setText(sipAccount.getStunServer());
                        registration.addElement("stunPort").setText(sipAccount.getStunPort());
                        registration.addElement("useStun").setText(String.valueOf(sipAccount.isUseStun()));
                        registration.addElement("voicemail").setText(sipAccount.getVoiceMailNumber());
                        registration.addElement("enabled").setText(String.valueOf(sipAccount.isEnabled()));
                        registration.addElement("outboundproxy").setText(sipAccount.getOutboundproxy());
                        registration.addElement("promptCredentials").setText(String.valueOf(sipAccount.isPromptCredentials()));
                    } else {
                        reply.getChildElement().addAttribute("type", "unregistered");
                    }
                } else if (sipAccount != null && !(status = iq.getChildElement().element("status")).getTextTrim().equals("")) {
                    sipAccount.setStatus(SipRegisterStatus.valueOf(status.getTextTrim()));
                    try {
                        SipAccountDAO.update(sipAccount);
                    }
                    catch (SQLException e) {
                        Log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            reply.setError(PacketError.Condition.service_unavailable);
        }
        try {
            this.componentManager.sendPacket((Component)this, (Packet)reply);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        Log.debug("PACKET SENT: " + reply.toXML());
    }

    public String getDescription() {
        return "SIP Admin Plugin";
    }

    public String getName() {
        return "SIPAdmin";
    }

    public void anonymousSessionCreated(Session arg0) {
    }

    public void anonymousSessionDestroyed(Session arg0) {
    }

    public void sessionCreated(Session arg0) {
    }

    public void sessionDestroyed(Session session) {
        String username = session.getAddress().toBareJID().split("@")[0];
        SipAccount sipAccount = SipAccountDAO.getAccountByUser(username);
        if (sipAccount != null) {
            try {
                sipAccount.setStatus(SipRegisterStatus.Unregistered);
                SipAccountDAO.update(sipAccount);
            }
            catch (SQLException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void resourceBound(Session session) {
    }
}

