/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.tester.security;

import java.text.ParseException;
import java.util.ListIterator;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.jivesoftware.openfire.sip.tester.Log;
import org.jivesoftware.openfire.sip.tester.security.CredentialsCache;
import org.jivesoftware.openfire.sip.tester.security.CredentialsCacheEntry;
import org.jivesoftware.openfire.sip.tester.security.MessageDigestAlgorithm;
import org.jivesoftware.openfire.sip.tester.security.SipSecurityException;
import org.jivesoftware.openfire.sip.tester.security.UserCredentials;
import org.jivesoftware.openfire.sip.tester.stack.SIPConfig;
import org.jivesoftware.openfire.sip.tester.stack.SipManager;

public class SipSecurityManager {
    private HeaderFactory headerFactory = null;
    private SipProvider transactionCreator = null;
    private SipManager sipManCallback = null;
    CredentialsCache cachedCredentials = new CredentialsCache();
    public UserCredentials defaultCredentials = null;

    public UserCredentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    public void setDefaultCredentials(UserCredentials defaultCredentials) {
        this.defaultCredentials = defaultCredentials;
    }

    public void setHeaderFactory(HeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
    }

    public void appendCredentialsIfNecessary(Request request) {
    }

    public ClientTransaction handleChallenge(Response challenge, ClientTransaction challengedTransaction) throws SipSecurityException, SipException, InvalidArgumentException, ParseException {
        try {
            String branchID = challengedTransaction.getBranchId();
            Request challengedRequest = challengedTransaction.getRequest();
            Request reoriginatedRequest = (Request)challengedRequest.clone();
            ListIterator authHeaders = null;
            if (challenge == null || reoriginatedRequest == null) {
                throw new NullPointerException("A null argument was passed to handle challenge.");
            }
            if (challenge.getStatusCode() == 401) {
                authHeaders = challenge.getHeaders("WWW-Authenticate");
            } else if (challenge.getStatusCode() == 407) {
                authHeaders = challenge.getHeaders("Proxy-Authenticate");
            }
            if (authHeaders == null) {
                throw new SecurityException("Could not find WWWAuthenticate or ProxyAuthenticate headers");
            }
            reoriginatedRequest.removeHeader("Authorization");
            reoriginatedRequest.removeHeader("Proxy-Authorization");
            CSeqHeader cSeq = (CSeqHeader)reoriginatedRequest.getHeader("CSeq");
            cSeq.setSequenceNumber(cSeq.getSequenceNumber() + 1);
            ClientTransaction retryTran = this.transactionCreator.getNewClientTransaction(reoriginatedRequest);
            WWWAuthenticateHeader authHeader = null;
            CredentialsCacheEntry ccEntry = null;
            while (authHeaders.hasNext()) {
                authHeader = (WWWAuthenticateHeader)authHeaders.next();
                String realm = authHeader.getRealm();
                ccEntry = this.cachedCredentials.remove(realm);
                UserCredentials defaultCredentials = new UserCredentials();
                FromHeader from = (FromHeader)reoriginatedRequest.getHeader("From");
                URI uri = from.getAddress().getURI();
                if (uri.isSipURI()) {
                    Log.debug("handleChallenge", SIPConfig.getAuthUserName());
                    String user = SIPConfig.getAuthUserName() != null ? SIPConfig.getAuthUserName() : ((SipURI)uri).getUser();
                    defaultCredentials.setAuthUserName(user == null ? SIPConfig.getUserName() : user);
                }
                boolean ccEntryHasSeenTran = false;
                if (ccEntry != null) {
                    ccEntryHasSeenTran = ccEntry.processResponse(branchID);
                }
                if (ccEntry == null || !authHeader.isStale() && ccEntryHasSeenTran) {
                    if (ccEntry == null) {
                        ccEntry = new CredentialsCacheEntry();
                        ccEntry.userCredentials = defaultCredentials;
                    }
                    SIPConfig.setUserName(ccEntry.userCredentials.getUserName());
                } else if (ccEntry == null || !ccEntryHasSeenTran || authHeader.isStale()) {
                    // empty if block
                }
                if (ccEntry.userCredentials == null) {
                    throw new SecurityException("Unable to authenticate with realm " + realm);
                }
                AuthorizationHeader authorization = this.getAuthorization(reoriginatedRequest.getMethod(), reoriginatedRequest.getRequestURI().toString(), reoriginatedRequest.getContent() == null ? "" : reoriginatedRequest.getContent().toString(), authHeader, ccEntry.userCredentials);
                ccEntry.processRequest(retryTran.getBranchId());
                this.cachedCredentials.cacheEntry(realm, ccEntry);
                reoriginatedRequest.addHeader((Header)authorization);
                if (!uri.isSipURI()) continue;
                ((SipURI)uri).setUser(ccEntry.userCredentials.getUserName());
                Address add = from.getAddress();
                add.setURI(uri);
                from.setAddress(add);
                reoriginatedRequest.setHeader((Header)from);
                if (challengedRequest.getMethod().equals("REGISTER")) {
                    ToHeader to = (ToHeader)reoriginatedRequest.getHeader("To");
                    add.setURI(uri);
                    to.setAddress(add);
                    reoriginatedRequest.setHeader((Header)to);
                }
                this.sipManCallback.setCurrentlyUsedURI(uri.toString());
                Log.debug("URI: " + uri.toString());
            }
            return retryTran;
        }
        catch (Exception e) {
            Log.debug("ERRO REG: " + e.toString());
            return null;
        }
    }

    private AuthorizationHeader getAuthorization(String method, String uri, String requestBody, WWWAuthenticateHeader authHeader, UserCredentials userCredentials) throws SecurityException {
        String response = null;
        try {
            Log.debug("getAuthorization", userCredentials.getAuthUserName());
            response = MessageDigestAlgorithm.calculateResponse(authHeader.getAlgorithm(), userCredentials.getAuthUserName(), authHeader.getRealm(), new String(userCredentials.getPassword()), authHeader.getNonce(), null, null, method, uri, requestBody, authHeader.getQop());
        }
        catch (NullPointerException exc) {
            throw new SecurityException("The authenticate header was malformatted");
        }
        Object authorization = null;
        try {
            authorization = authHeader instanceof ProxyAuthenticateHeader ? this.headerFactory.createProxyAuthorizationHeader(authHeader.getScheme()) : this.headerFactory.createAuthorizationHeader(authHeader.getScheme());
            authorization.setUsername(userCredentials.getAuthUserName());
            authorization.setRealm(authHeader.getRealm());
            authorization.setNonce(authHeader.getNonce());
            authorization.setParameter("uri", uri);
            authorization.setResponse(response);
            if (authHeader.getAlgorithm() != null) {
                authorization.setAlgorithm(authHeader.getAlgorithm());
            }
            if (authHeader.getOpaque() != null) {
                authorization.setOpaque(authHeader.getOpaque());
            }
            authorization.setResponse(response);
        }
        catch (ParseException ex) {
            throw new SecurityException("Failed to create an authorization header!");
        }
        return authorization;
    }

    public void cacheCredentials(String realm, UserCredentials credentials) {
        CredentialsCacheEntry ccEntry = new CredentialsCacheEntry();
        ccEntry.userCredentials = credentials;
        this.cachedCredentials.cacheEntry(realm, ccEntry);
    }

    public void setTransactionCreator(SipProvider transactionCreator) {
        this.transactionCreator = transactionCreator;
    }

    public void setSipManCallback(SipManager sipManCallback) {
        this.sipManCallback = sipManCallback;
    }
}

