/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.tester.stack;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.openfire.sip.sipaccount.SipAccount;
import org.jivesoftware.openfire.sip.tester.Log;
import org.jivesoftware.openfire.sip.tester.comm.CommunicationsException;
import org.jivesoftware.openfire.sip.tester.comm.CommunicationsListener;
import org.jivesoftware.openfire.sip.tester.stack.RegistrationEvent;
import org.jivesoftware.openfire.sip.tester.stack.SIPConfig;
import org.jivesoftware.openfire.sip.tester.stack.SipManager;
import org.jivesoftware.openfire.sip.tester.stack.TestListener;

public class SIPTest
implements CommunicationsListener {
    private SipAccount sipAccount;
    private Result result = null;
    private SipManager sipManager = null;
    private List<TestListener> listeners = new ArrayList<TestListener>();

    public SIPTest(InetAddress localAddress, SipAccount sipAccount) {
        this.sipAccount = sipAccount;
        this.sipManager = new SipManager(localAddress);
    }

    public Result getResult() {
        return this.result;
    }

    private void setResult(Result result) {
        if (!result.equals((Object)this.result)) {
            this.fireResultChanged(this.result, result);
        }
        this.result = result;
    }

    public void test(int timeout) {
        this.test(timeout, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(int timeout, int tries) {
        for (int i = 0; i < tries && (this.getResult() == null || Result.Timeout.equals((Object)this.getResult())); ++i) {
            if (this.sipManager.isStarted()) {
                try {
                    this.sipManager.stop();
                }
                catch (CommunicationsException e) {
                    e.printStackTrace();
                }
            }
            this.setResult(Result.Trying);
            SIPConfig.setRegistrarAddress(this.sipAccount.getServer());
            SIPConfig.setAuthenticationRealm(this.sipAccount.getServer());
            SIPConfig.setDefaultDomain(this.sipAccount.getServer());
            try {
                this.sipManager.start();
                this.sipManager.addCommunicationsListener(this);
                try {
                    this.sipManager.startRegisterProcess(this.sipAccount.getSipUsername(), this.sipAccount.getAuthUsername(), this.sipAccount.getPassword());
                }
                catch (CommunicationsException e) {
                    this.setResult(Result.NetworkError);
                    Log.error(e.getMessage(), e);
                }
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    Log.error(e.getMessage(), e);
                }
                if (!this.getResult().equals((Object)Result.Trying)) continue;
                this.setResult(Result.Timeout);
                continue;
            }
            catch (CommunicationsException e) {
                this.setResult(Result.NetworkError);
                Log.error(e.getMessage(), e);
                continue;
            }
            finally {
                try {
                    this.sipManager.stop();
                }
                catch (CommunicationsException e) {
                    Log.error(e.getMessage(), e);
                }
            }
        }
    }

    public void fireResultChanged(Result old, Result current) {
        for (TestListener listener : this.listeners) {
            listener.resultChanged(old, current);
        }
    }

    public void addListener(TestListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TestListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void registered(RegistrationEvent evt) {
        this.setResult(Result.Successfully);
        try {
            this.sipManager.unregister();
        }
        catch (CommunicationsException e) {
            Log.error(e.getMessage(), e);
        }
    }

    @Override
    public void registering(RegistrationEvent evt) {
    }

    @Override
    public void registrationFailed(RegistrationEvent evt) {
        if (evt.getType().equals((Object)RegistrationEvent.Type.NotFound)) {
            this.setResult(Result.WrongUser);
        } else if (evt.getType().equals((Object)RegistrationEvent.Type.WrongPass)) {
            this.setResult(Result.WrongPass);
        } else if (evt.getType().equals((Object)RegistrationEvent.Type.Forbidden)) {
            this.setResult(Result.Forbidden);
        } else if (evt.getType().equals((Object)RegistrationEvent.Type.WrongAuthUser)) {
            this.setResult(Result.WrongAuthUser);
        }
    }

    @Override
    public void unregistering(RegistrationEvent evt) {
    }

    @Override
    public void unregistered(RegistrationEvent evt) {
        try {
            this.sipManager.stop();
            Log.debug("Stopped");
        }
        catch (CommunicationsException e) {
            Log.error(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            SipAccount sipAccount = new SipAccount("", "", "", "", "", "", "", false);
            SIPTest sipTest = new SIPTest(localAddress, sipAccount);
            sipTest.test(3000, 2);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public static enum Result {
        Successfully,
        WrongUser,
        WrongPass,
        NetworkError,
        Trying,
        Timeout,
        Forbidden,
        WrongAuthUser;

    }
}

