/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.threaddump;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.igniterealtime.openfire.plugin.threaddump.ThreadDump;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.Evaluator;
import org.igniterealtime.openfire.plugin.threaddump.formatter.DefaultThreadDumpFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpCheckTimerTask
extends TimerTask {
    private static final Logger Log = LoggerFactory.getLogger(DumpCheckTimerTask.class);
    private final Duration backoff;
    private final ConcurrentMap<Evaluator, Instant> evaluators = new ConcurrentHashMap<Evaluator, Instant>();
    private Instant lastDump = Instant.EPOCH;

    public DumpCheckTimerTask(Duration backoff) {
        this.backoff = backoff;
    }

    public void add(Evaluator evaluator) {
        this.evaluators.putIfAbsent(evaluator, Instant.EPOCH);
    }

    public void remove(Evaluator evaluator) {
        this.evaluators.remove(evaluator);
    }

    @Override
    public void run() {
        if (this.evaluators.isEmpty()) {
            Log.trace("Aborting this run: No evaluators are configured.");
            return;
        }
        if (Instant.now().isBefore(this.lastDump.plus(this.backoff))) {
            Log.trace("Aborting this run: configuration disallows for more than 1 thread dump per {}. Last thread dump was created at {}.", (Object)this.backoff, (Object)this.lastDump);
            return;
        }
        boolean eligible = false;
        Set due = this.evaluators.entrySet().stream().filter(entry -> ((Instant)entry.getValue()).plus(((Evaluator)entry.getKey()).getInterval()).isBefore(Instant.now())).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (due.isEmpty()) {
            Log.trace("Aborting this run: No evaluators are due to run.");
            return;
        }
        for (Evaluator evaluator : due) {
            Log.trace("Running evaluator {}", (Object)evaluator.getClass().getSimpleName());
            try {
                boolean result = evaluator.shouldCreateThreadDump();
                this.evaluators.computeIfPresent(evaluator, (e, i) -> Instant.now());
                if (!result) continue;
                Log.info("Evaluator {} requested a thread dump to be created.", (Object)evaluator.getClass().getSimpleName());
                eligible = true;
                break;
            }
            catch (Exception e2) {
                Log.warn("An unexpected exception occurred while determining of a thread dump should be created, using evaluator {}.", (Object)evaluator, (Object)e2);
            }
        }
        Log.debug("Run result: a thread dump {} be created.", (Object)(eligible ? "should" : "should not"));
        if (eligible) {
            DumpCheckTimerTask.dump();
            this.lastDump = Instant.now();
        }
    }

    private static void dump() {
        Log.info("Creating thread dump.");
        ThreadDump td = ThreadDump.getInstance();
        String dump = new DefaultThreadDumpFormatter().format(td);
        LoggerFactory.getLogger((String)"threaddump").info(dump);
    }

    public Instant getLastDumpInstant() {
        return this.lastDump;
    }
}

