/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.threaddump;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class ThreadDump {
    private final List<Trace> traces;
    private final long[] deadLockedThreadIDs;

    public static ThreadDump getInstance() {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = mxBean.dumpAllThreads(mxBean.isObjectMonitorUsageSupported(), mxBean.isSynchronizerUsageSupported());
        Map<Long, Thread> threads = Thread.getAllStackTraces().keySet().stream().collect(Collectors.toMap(Thread::getId, thread -> thread));
        List<Trace> traces = Arrays.stream(threadInfos).map(threadInfo -> {
            long threadId = threadInfo.getThreadId();
            OptionalLong cpuTime = mxBean.isThreadCpuTimeSupported() && mxBean.isThreadCpuTimeEnabled() ? OptionalLong.of(mxBean.getThreadCpuTime(threadId)) : OptionalLong.empty();
            OptionalLong userTime = mxBean.isThreadCpuTimeSupported() && mxBean.isThreadCpuTimeEnabled() ? OptionalLong.of(mxBean.getThreadUserTime(threadId)) : OptionalLong.empty();
            Thread thread = (Thread)threads.get(threadId);
            OptionalInt priority = thread != null ? OptionalInt.of(thread.getPriority()) : OptionalInt.empty();
            Optional isDaemon = thread != null ? Optional.of(thread.isDaemon()) : Optional.empty();
            return new Trace(threadId, (ThreadInfo)threadInfo, priority, isDaemon, cpuTime, userTime);
        }).collect(Collectors.toList());
        long[] deadlockedThreadIDs = mxBean.isSynchronizerUsageSupported() ? mxBean.findDeadlockedThreads() : null;
        return new ThreadDump(traces, deadlockedThreadIDs);
    }

    private ThreadDump(List<Trace> traces, long[] deadLockedThreadIDs) {
        this.traces = traces;
        this.deadLockedThreadIDs = deadLockedThreadIDs;
    }

    public List<Trace> getTraces() {
        return new CopyOnWriteArrayList<Trace>(this.traces);
    }

    public long[] getDeadLockedThreadIDs() {
        return this.deadLockedThreadIDs == null ? null : (long[])this.deadLockedThreadIDs.clone();
    }

    public static class Trace {
        private final long threadId;
        private final ThreadInfo threadInfo;
        private final OptionalInt threadPriority;
        private final Optional<Boolean> isThreadDeamon;
        private final OptionalLong cpuTime;
        private final OptionalLong userTime;

        private Trace(long threadId, ThreadInfo threadInfo, OptionalInt threadPriority, Optional<Boolean> isThreadDeamon, OptionalLong cpuTime, OptionalLong userTime) {
            this.threadId = threadId;
            this.threadInfo = threadInfo;
            this.threadPriority = threadPriority;
            this.isThreadDeamon = isThreadDeamon;
            this.cpuTime = cpuTime;
            this.userTime = userTime;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public ThreadInfo getThreadInfo() {
            return this.threadInfo;
        }

        public StackTraceElement[] getStack() {
            return this.threadInfo.getStackTrace();
        }

        public String getThreadName() {
            return this.threadInfo.getThreadName();
        }

        public OptionalInt threadPriority() {
            return this.threadPriority;
        }

        public Optional<Boolean> isThreadDeamon() {
            return this.isThreadDeamon;
        }

        public Thread.State getThreadState() {
            return this.threadInfo.getThreadState();
        }

        public OptionalLong getThreadCpuTime() {
            return this.cpuTime;
        }

        public OptionalLong getThreadUserTime() {
            return this.userTime;
        }
    }
}

