/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.threaddump;

import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.igniterealtime.openfire.plugin.threaddump.DumpCheckTimerTask;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.CoreThreadPoolsEvaluator;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.DatabaseConnectionPoolEvaluator;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.DeadlockEvaluator;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.Evaluator;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.TaskEngineEvaluator;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpPlugin
implements Plugin,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(ThreadDumpPlugin.class);
    private static final AtomicInteger nextTimerSerial = new AtomicInteger(1);
    private Timer timer;
    private DumpCheckTimerTask task;

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        PropertyEventDispatcher.addListener((PropertyEventListener)this);
        this.configMonitor();
    }

    public void destroyPlugin() {
        PropertyEventDispatcher.removeListener((PropertyEventListener)this);
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.task = null;
    }

    public synchronized void configMonitor() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer("ThreadDump-Timer-" + nextTimerSerial.getAndIncrement());
        this.task = null;
        if (this.isTaskEnabled()) {
            long delayMS = this.getTaskDelay().toMillis();
            long intervalMS = this.getTaskInterval().toMillis();
            long backoffMS = this.getTaskBackoff().toMillis();
            Set<Class<? extends Evaluator>> evaluatorClasses = this.getTaskEvaluatorClasses();
            HashSet<Evaluator> evaluators = new HashSet<Evaluator>();
            for (Class<? extends Evaluator> evaluatorClass : evaluatorClasses) {
                try {
                    Evaluator evaluator2 = evaluatorClass.newInstance();
                    if (evaluator2.isSupported()) {
                        evaluators.add(evaluator2);
                        continue;
                    }
                    Log.info("Not loading evaluator {} as its functionality is not supported by the configuration of this Openfire server.", (Object)evaluator2.getClass().getSimpleName());
                }
                catch (Exception e) {
                    Log.warn("Unable to instantiate evaluator {}", evaluatorClass, (Object)e);
                }
            }
            if (!evaluators.isEmpty()) {
                Duration backoff = Duration.of(backoffMS, ChronoUnit.MILLIS);
                Log.info("Scheduling a check for thread dump necessity evaluation every {}ms (starting after a delay of {}ms. No more than one dump per {} will be generated.", new Object[]{intervalMS, delayMS, backoff});
                evaluators.forEach(evaluator -> Log.info("Enabled evaluator {}, running every {}", (Object)evaluator.getClass().getCanonicalName(), (Object)evaluator.getInterval()));
                this.task = new DumpCheckTimerTask(backoff);
                evaluators.forEach(this.task::add);
                this.timer.schedule((TimerTask)this.task, delayMS, intervalMS);
            }
        }
    }

    public void propertySet(String property, Map<String, Object> params) {
        if (property.startsWith("threaddump.task.")) {
            this.configMonitor();
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
        if (property.startsWith("threaddump.task.")) {
            this.configMonitor();
        }
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }

    public boolean isTaskEnabled() {
        return JiveGlobals.getBooleanProperty((String)"threaddump.task.enable", (boolean)true);
    }

    public void setTaskEnabled(boolean enabled) {
        JiveGlobals.setProperty((String)"threaddump.task.enable", (String)Boolean.toString(enabled));
    }

    public Duration getTaskDelay() {
        return Duration.of(JiveGlobals.getLongProperty((String)"threaddump.task.delay", (long)Duration.of(60L, ChronoUnit.SECONDS).toMillis()), ChronoUnit.MILLIS);
    }

    public void setTaskDelay(Duration duration) {
        JiveGlobals.setProperty((String)"threaddump.task.delay", (String)String.valueOf(duration.toMillis()));
    }

    public Duration getTaskInterval() {
        return Duration.of(JiveGlobals.getLongProperty((String)"threaddump.task.interval", (long)Duration.of(5L, ChronoUnit.SECONDS).toMillis()), ChronoUnit.MILLIS);
    }

    public void setTaskInterval(Duration duration) {
        JiveGlobals.setProperty((String)"threaddump.task.interval", (String)String.valueOf(duration.toMillis()));
    }

    public Duration getTaskBackoff() {
        return Duration.of(JiveGlobals.getLongProperty((String)"threaddump.task.backoff", (long)Duration.of(5L, ChronoUnit.MINUTES).toMillis()), ChronoUnit.MILLIS);
    }

    public void setTaskBackoff(Duration duration) {
        JiveGlobals.setProperty((String)"threaddump.task.backoff", (String)String.valueOf(duration.toMillis()));
    }

    public Set<Class<? extends Evaluator>> getTaskEvaluatorClasses() {
        HashSet<Class<? extends Evaluator>> result = new HashSet<Class<? extends Evaluator>>();
        String evaluatorNames = JiveGlobals.getProperty((String)"threaddump.task.evaluators", (String)(CoreThreadPoolsEvaluator.class.getCanonicalName() + ", " + DeadlockEvaluator.class.getCanonicalName() + ", " + TaskEngineEvaluator.class.getCanonicalName() + ", " + DatabaseConnectionPoolEvaluator.class.getCanonicalName()));
        if (evaluatorNames != null) {
            for (String evaluatorName : evaluatorNames.split("\\s*,\\s*")) {
                if (evaluatorName == null || evaluatorName.isEmpty()) continue;
                try {
                    Class<?> evaluator = Class.forName(evaluatorName);
                    result.add(evaluator);
                }
                catch (Exception e) {
                    Log.warn("Unable to load evaluator {} class.", (Object)evaluatorName, (Object)e);
                }
            }
        }
        return result;
    }

    public void setTaskEvaluatorClasses(Set<Class<? extends Evaluator>> evaluators) {
        String propValue = evaluators.stream().map(Class::getCanonicalName).collect(Collectors.joining(", "));
        JiveGlobals.setProperty((String)"threaddump.task.evaluators", (String)propValue);
    }

    public Instant getLastDumpInstant() {
        if (this.task != null && this.task.getLastDumpInstant() != null && !this.task.getLastDumpInstant().equals(Instant.EPOCH)) {
            return this.task.getLastDumpInstant();
        }
        return null;
    }
}

