/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.threaddump.evaluator;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.Evaluator;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.spi.ConnectionListener;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreThreadPoolsEvaluator
implements Evaluator {
    private static final Logger Log = LoggerFactory.getLogger(CoreThreadPoolsEvaluator.class);
    private int successiveHits = 0;

    @Override
    public Duration getInterval() {
        long backoffMS = JiveGlobals.getLongProperty((String)"threaddump.evaluator.threadpools.interval", (long)Duration.of(5L, ChronoUnit.SECONDS).toMillis());
        return Duration.of(backoffMS, ChronoUnit.MILLIS);
    }

    @Override
    public boolean shouldCreateThreadDump() {
        Log.trace("Evaluating...");
        if (this.checkPools()) {
            Log.trace("At least one pool is at max. Increasing successive hit count.");
            ++this.successiveHits;
            int limit = JiveGlobals.getIntProperty((String)"threaddump.evaluator.threadpools.successive-hits", (int)2);
            if (this.successiveHits >= limit) {
                Log.trace("Successive hit count ({}) has hit limit ({}).", (Object)this.successiveHits, (Object)limit);
                this.successiveHits = 0;
                Log.debug("Do create a thread dump.");
                return true;
            }
        } else {
            this.successiveHits = 0;
        }
        Log.debug("No need to create a thread dump.");
        return false;
    }

    protected boolean checkPools() {
        int busyPercentageLimit = JiveGlobals.getIntProperty((String)"threaddump.evaluator.threadpools.busy-percentage-max", (int)90);
        Set listeners = ((ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager()).getListeners();
        for (ConnectionListener listener : listeners) {
            DefaultIoFilterChainBuilder filterChain;
            NioSocketAcceptor socketAcceptor = listener.getSocketAcceptor();
            if (socketAcceptor == null || (filterChain = socketAcceptor.getFilterChain()) == null || !filterChain.contains("threadModel")) continue;
            ExecutorFilter executorFilter = (ExecutorFilter)filterChain.get("threadModel");
            int max = ((ThreadPoolExecutor)executorFilter.getExecutor()).getMaximumPoolSize();
            int act = ((ThreadPoolExecutor)executorFilter.getExecutor()).getActiveCount();
            int busyPercentage = (int)Math.round((double)act * 100.0 / (double)max);
            Log.trace("{}% ({}/{}) thread running in pool {} {}. Threshold: {}%", new Object[]{busyPercentage, act, max, listener.getType(), listener.getTLSPolicy(), busyPercentageLimit});
            if (busyPercentage <= busyPercentageLimit) continue;
            return true;
        }
        return false;
    }
}

