/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.threaddump.evaluator;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.Evaluator;
import org.jivesoftware.database.ConnectionProvider;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.database.DefaultConnectionProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConnectionPoolEvaluator
implements Evaluator {
    private static final Logger Log = LoggerFactory.getLogger(DatabaseConnectionPoolEvaluator.class);
    private int successiveHits = 0;

    @Override
    public Duration getInterval() {
        long backoffMS = JiveGlobals.getLongProperty((String)"threaddump.evaluator.dbpool.interval", (long)Duration.of(5L, ChronoUnit.SECONDS).toMillis());
        return Duration.of(backoffMS, ChronoUnit.MILLIS);
    }

    @Override
    public boolean shouldCreateThreadDump() {
        Log.trace("Evaluating...");
        if (this.checkPool()) {
            Log.trace("At least one statistic for the TaskEngine is at max. Increasing successive hit count.");
            ++this.successiveHits;
            int limit = JiveGlobals.getIntProperty((String)"threaddump.evaluator.dbpool.successive-hits", (int)2);
            if (this.successiveHits >= limit) {
                Log.trace("Successive hit count ({}) has hit limit ({}).", (Object)this.successiveHits, (Object)limit);
                this.successiveHits = 0;
                Log.debug("Do create a thread dump.");
                return true;
            }
        } else {
            this.successiveHits = 0;
        }
        Log.debug("No need to create a thread dump.");
        return false;
    }

    protected boolean checkPool() {
        int busyPercentageLimit = JiveGlobals.getIntProperty((String)"threaddump.evaluator.dbpool.busy-percentage-max", (int)90);
        ConnectionProvider connectionProvider = DbConnectionManager.getConnectionProvider();
        if (this.isSupported()) {
            DefaultConnectionProvider defaultConnectionProvider = (DefaultConnectionProvider)connectionProvider;
            int activeConnections = defaultConnectionProvider.getActiveConnections();
            int maxConnections = defaultConnectionProvider.getMaxConnections();
            int busyPercentage = 100 * activeConnections / maxConnections;
            Log.trace("{}% ({}/{}) connections of database pool are currently active. Threshold: {}%", new Object[]{busyPercentage, activeConnections, maxConnections, busyPercentageLimit});
            return busyPercentage > busyPercentageLimit;
        }
        Log.debug("This server is using {} as the database connection provider for Openfire, which is not supported by this evaluator.", (Object)connectionProvider.getClass().getSimpleName());
        return false;
    }

    @Override
    public boolean isSupported() {
        return DbConnectionManager.getConnectionProvider() instanceof DefaultConnectionProvider && DbConnectionManager.getConnectionProvider().isPooled();
    }
}

