/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.threaddump.evaluator;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.Evaluator;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadlockEvaluator
implements Evaluator {
    private static final Logger Log = LoggerFactory.getLogger(DeadlockEvaluator.class);

    @Override
    public Duration getInterval() {
        long backoffMS = JiveGlobals.getLongProperty((String)"threaddump.evaluator.deadlock.interval", (long)Duration.of(5L, ChronoUnit.MINUTES).toMillis());
        return Duration.of(backoffMS, ChronoUnit.MILLIS);
    }

    @Override
    public boolean shouldCreateThreadDump() {
        Log.trace("Evaluating...");
        boolean result = this.detectDeadlock();
        Log.debug("Deadlock {}", (Object)(result ? "detected!" : "not detected."));
        return result;
    }

    protected boolean detectDeadlock() {
        long[] deadlockedThreads = ManagementFactory.getThreadMXBean().findDeadlockedThreads();
        return deadlockedThreads != null && deadlockedThreads.length > 0;
    }
}

