/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.threaddump.evaluator;

import java.lang.reflect.Field;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ThreadPoolExecutor;
import org.igniterealtime.openfire.plugin.threaddump.evaluator.Evaluator;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskEngineEvaluator
implements Evaluator {
    private static final Logger Log = LoggerFactory.getLogger(TaskEngineEvaluator.class);
    private int successiveHits = 0;

    @Override
    public Duration getInterval() {
        long backoffMS = JiveGlobals.getLongProperty((String)"threaddump.evaluator.taskengine.interval", (long)Duration.of(5L, ChronoUnit.SECONDS).toMillis());
        return Duration.of(backoffMS, ChronoUnit.MILLIS);
    }

    @Override
    public boolean shouldCreateThreadDump() {
        Log.trace("Evaluating...");
        if (this.checkPool()) {
            Log.trace("At least one statistic for the TaskEngine is at max. Increasing successive hit count.");
            ++this.successiveHits;
            int limit = JiveGlobals.getIntProperty((String)"threaddump.evaluator.taskengine.successive-hits", (int)2);
            if (this.successiveHits >= limit) {
                Log.trace("Successive hit count ({}) has hit limit ({}).", (Object)this.successiveHits, (Object)limit);
                this.successiveHits = 0;
                Log.debug("Do create a thread dump.");
                return true;
            }
        } else {
            this.successiveHits = 0;
        }
        Log.debug("No need to create a thread dump.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkPool() {
        int maxActiveCount = JiveGlobals.getIntProperty((String)"threaddump.evaluator.taskengine.max-threads", (int)300);
        int maxPoolsize = JiveGlobals.getIntProperty((String)"threaddump.evaluator.taskengine.max-poolsize", (int)500);
        Field executorField = null;
        try {
            executorField = TaskEngine.class.getDeclaredField("executor");
            executorField.setAccessible(true);
            ThreadPoolExecutor executor = (ThreadPoolExecutor)executorField.get(TaskEngine.getInstance());
            int activeCount = executor.getActiveCount();
            if (activeCount >= maxActiveCount) {
                boolean bl = true;
                return bl;
            }
            int poolSize = executor.getPoolSize();
            if (poolSize >= maxPoolsize) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable t) {
            Log.warn("An exception occurred while trying to check the pool of TaskEngine.", t);
        }
        finally {
            if (executorField != null) {
                executorField.setAccessible(false);
            }
        }
        return false;
    }
}

