/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.threaddump.formatter;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.igniterealtime.openfire.plugin.threaddump.ThreadDump;
import org.igniterealtime.openfire.plugin.threaddump.formatter.ThreadDumpFormatter;
import org.jivesoftware.openfire.XMPPServer;

public class DefaultThreadDumpFormatter
implements ThreadDumpFormatter {
    private Writer writer;

    @Override
    public String format(ThreadDump threadDump) {
        try {
            String ofVersion;
            this.writer = new StringWriter(){

                @Override
                public void write(String str) {
                    super.write(str + System.lineSeparator());
                }
            };
            try {
                ofVersion = XMPPServer.getInstance().getServerInfo().getVersion().toString();
            }
            catch (Exception e) {
                ofVersion = "UNKOWN";
            }
            String jvmVendor = System.getProperty("java.vendor");
            String jvmVersion = System.getProperty("java.version");
            String osArch = System.getProperty("os.arch");
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            this.writer.write(new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ").format(new Date(System.currentTimeMillis())));
            this.writer.write("Full Java thread dump, Openfire " + ofVersion + ", Java " + jvmVersion + " " + jvmVendor + ", " + osName + " " + osArch + " " + osVersion);
            this.writer.write("");
            for (ThreadDump.Trace trace : threadDump.getTraces()) {
                this.printThreadInfo(trace);
                this.printLockedSynchronizers(trace.getThreadInfo().getLockedSynchronizers());
            }
            this.writer.write("");
            this.printDeadlockInfo(threadDump);
            return this.writer.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to format thread dump.", e);
        }
    }

    private void printThreadInfo(ThreadDump.Trace trace) throws IOException {
        this.printThread(trace);
        StackTraceElement[] stacktrace = trace.getThreadInfo().getStackTrace();
        MonitorInfo[] monitors = trace.getThreadInfo().getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            this.writer.write("\tat " + ste.toString());
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                this.writer.write("\t- locked " + mi);
            }
        }
        this.writer.write("");
    }

    private void printThread(ThreadDump.Trace trace) throws IOException {
        ThreadInfo ti;
        StringBuilder sb = new StringBuilder();
        sb.append('\"').append(trace.getThreadName()).append('\"');
        sb.append(" #").append(trace.getThreadId());
        if (trace.isThreadDeamon().isPresent() && trace.isThreadDeamon().get().booleanValue()) {
            sb.append(" daemon");
        }
        if (trace.threadPriority().isPresent()) {
            sb.append(" prio=").append(trace.threadPriority().getAsInt());
        }
        if ((ti = trace.getThreadInfo()).getLockName() != null) {
            sb.append(" waiting on lock");
        }
        if (trace.getThreadInfo().isSuspended()) {
            sb.append(" suspended");
        }
        if (trace.getThreadInfo().isInNative()) {
            sb.append(" running in native");
        }
        sb.append(System.lineSeparator());
        sb.append("   java.lang.Thread.State: ").append((Object)trace.getThreadState());
        LockInfo lockInfo = trace.getThreadInfo().getLockInfo();
        if (lockInfo != null) {
            sb.append(System.lineSeparator());
            switch (trace.getThreadState()) {
                case BLOCKED: {
                    sb.append("\t- blocked on ").append(lockInfo);
                    break;
                }
                case WAITING: 
                case TIMED_WAITING: {
                    sb.append("\t- waiting on ").append(lockInfo);
                    break;
                }
                default: {
                    sb.append("\t- ").append(trace.getThreadState().toString().toLowerCase()).append(" on ").append(lockInfo);
                }
            }
            if (ti.getLockOwnerName() != null) {
                sb.append(" (owned by ").append(ti.getLockOwnerName()).append(" id=").append(ti.getLockOwnerId()).append(")");
            }
        }
        this.writer.write(sb.toString());
    }

    private void printLockedSynchronizers(LockInfo[] locks) throws IOException {
        if (locks != null && locks.length > 0) {
            this.writer.write("   Locked ownable synchronizers:");
            for (LockInfo li : locks) {
                this.writer.write("     - " + li);
            }
            this.writer.write("");
        }
    }

    private void printDeadlockInfo(ThreadDump threadDump) throws IOException {
        if (threadDump.getDeadLockedThreadIDs() != null && threadDump.getDeadLockedThreadIDs().length != 0) {
            this.writer.write("Deadlock detected!");
            for (long deadLockedThreadID : threadDump.getDeadLockedThreadIDs()) {
                StringBuilder sb = new StringBuilder();
                String threadName = threadDump.getTraces().stream().filter(t -> t.getThreadId() == deadLockedThreadID).findAny().get().getThreadName();
                MonitorInfo[] lockedMonitors = threadDump.getTraces().stream().filter(t -> t.getThreadId() == deadLockedThreadID).findAny().map(t -> t.getThreadInfo().getLockedMonitors()).get();
                LockInfo[] lockedSynchronizers = threadDump.getTraces().stream().filter(t -> t.getThreadId() == deadLockedThreadID).findAny().map(t -> t.getThreadInfo().getLockedSynchronizers()).get();
                String waitName = threadDump.getTraces().stream().filter(t -> t.getThreadId() == deadLockedThreadID).findAny().map(t -> t.getThreadInfo().getLockName()).get();
                String waitOwnerName = threadDump.getTraces().stream().filter(t -> t.getThreadId() == deadLockedThreadID).findAny().map(t -> t.getThreadInfo().getLockOwnerName()).get();
                long waitOwnerId = threadDump.getTraces().stream().filter(t -> t.getThreadId() == deadLockedThreadID).findAny().map(t -> t.getThreadInfo().getLockOwnerId()).get();
                sb.append(" - #").append(deadLockedThreadID).append(" (").append(threadName).append(") locked");
                for (MonitorInfo monitorInfo : lockedMonitors) {
                    sb.append(" ").append(monitorInfo);
                }
                for (LockInfo lockInfo : lockedSynchronizers) {
                    sb.append(" ").append(lockInfo);
                }
                sb.append(", waiting for ").append(waitName).append(" owned by #").append(waitOwnerId).append(" (").append(waitOwnerName).append(")");
                this.writer.write(sb.toString());
            }
        } else {
            this.writer.write("No deadlock detected.");
        }
    }
}

