/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.threaddump.formatter;

import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.igniterealtime.openfire.plugin.threaddump.ThreadDump;
import org.igniterealtime.openfire.plugin.threaddump.formatter.ThreadDumpFormatter;

public class SimpleFormatter
implements ThreadDumpFormatter {
    public static final String NEWLINE = System.lineSeparator();

    @Override
    public String format(ThreadDump threadDump) {
        StringBuilder sb = new StringBuilder();
        sb.append("Dump of " + threadDump.getTraces().size() + " threads at " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z").format(new Date(System.currentTimeMillis())) + NEWLINE + NEWLINE);
        for (ThreadDump.Trace trace : threadDump.getTraces()) {
            sb.append("\"" + trace.getThreadName() + "\"");
            if (trace.threadPriority().isPresent()) {
                sb.append(" prio=").append(trace.threadPriority().getAsInt());
            }
            sb.append(" tid=").append(trace.getThreadId());
            sb.append(" ").append((Object)trace.getThreadState());
            if (trace.isThreadDeamon().isPresent()) {
                sb.append(" ").append(trace.isThreadDeamon().get() != false ? "daemon" : "worker");
            }
            sb.append(NEWLINE);
            ThreadInfo threadInfo = trace.getThreadInfo();
            if (threadInfo != null) {
                sb.append("    native=" + threadInfo.isInNative() + ", suspended=" + threadInfo.isSuspended() + ", block=" + threadInfo.getBlockedCount() + ", wait=" + threadInfo.getWaitedCount() + NEWLINE);
                sb.append("    lock=" + threadInfo.getLockName() + " owned by " + threadInfo.getLockOwnerName() + " (" + threadInfo.getLockOwnerId() + "), cpu=" + trace.getThreadCpuTime() + ", user=" + trace.getThreadUserTime() + NEWLINE);
            }
            for (StackTraceElement element : trace.getStack()) {
                sb.append("    ");
                String eleStr = element.toString();
                sb.append("    ");
                sb.append(eleStr);
                sb.append(NEWLINE);
            }
            sb.append(NEWLINE);
        }
        if (threadDump.getDeadLockedThreadIDs() != null && threadDump.getDeadLockedThreadIDs().length != 0) {
            sb.append("Deadlock detected!");
            sb.append("Deadlocked threads: ");
            for (Object deadLockedThreadID : (Object)threadDump.getDeadLockedThreadIDs()) {
                sb.append(" - ").append((long)deadLockedThreadID);
            }
        } else {
            sb.append("No deadlock detected.");
        }
        return sb.toString();
    }
}

