/*
 * Decompiled with CFR 0.152.
 */
package org.tiki.tikitoken;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiki.tikitoken.TikiTokenSaslServer;

public class TikiTokenSaslServerFactory
implements SaslServerFactory {
    private static final Logger Log = LoggerFactory.getLogger(TikiTokenSaslServerFactory.class);

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Set<String> mechanismNames = this.getMechanismNamesSet(props);
        if (mechanismNames.contains(mechanism) && mechanism.equalsIgnoreCase("TIKITOKEN")) {
            Log.debug("Instantiating a new TikiTokenSaslServer instance.");
            return new TikiTokenSaslServer();
        }
        Log.debug("Unable to instantiate a SaslServer instance that matches the requested properties.");
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        Set<String> result = this.getMechanismNamesSet(props);
        return result.toArray(new String[result.size()]);
    }

    protected final Set<String> getMechanismNamesSet(Map<String, ?> props) {
        HashSet<String> supportedMechanisms = new HashSet<String>();
        supportedMechanisms.add("TIKITOKEN");
        if (props != null) {
            for (Map.Entry<String, ?> prop : props.entrySet()) {
                if (!(prop.getValue() instanceof String)) continue;
                String name = prop.getKey();
                String value = (String)prop.getValue();
                if (!"javax.security.sasl.policy.noplaintext".equalsIgnoreCase(name) || !"true".equalsIgnoreCase(value)) continue;
                Log.info("Removing '{}' mechanism, as the provided properties define a NOPLAINTEXT policy.", (Object)"TIKITOKEN");
                supportedMechanisms.remove("TIKITOKEN");
            }
        }
        return supportedMechanisms;
    }
}

