/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;
import org.jxmpp.util.XmppDateTime;

public class FormField
implements NamedElement {
    public static final String ELEMENT = "field";
    public static final String FORM_TYPE = "FORM_TYPE";
    private final String variable;
    private String description;
    private boolean required = false;
    private String label;
    private Type type;
    private final List<Option> options = new ArrayList<Option>();
    private final List<CharSequence> values = new ArrayList<CharSequence>();
    private ValidateElement validateElement;

    public FormField(String variable) {
        this.variable = (String)StringUtils.requireNotNullOrEmpty((CharSequence)variable, (String)"Variable must not be null or empty");
    }

    public FormField() {
        this.variable = null;
        this.type = Type.fixed;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Option> getOptions() {
        List<Option> list = this.options;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Option>(this.options));
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CharSequence> getValues() {
        List<CharSequence> list = this.values;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<CharSequence>(this.values));
        }
    }

    public List<String> getValuesAsString() {
        List<CharSequence> valuesAsCharSequence = this.getValues();
        ArrayList<String> res = new ArrayList<String>(valuesAsCharSequence.size());
        for (CharSequence value : valuesAsCharSequence) {
            res.add(value.toString());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstValue() {
        CharSequence firstValue;
        List<CharSequence> list = this.values;
        synchronized (list) {
            firstValue = this.values.get(0);
        }
        if (firstValue == null) {
            return null;
        }
        return firstValue.toString();
    }

    public Date getFirstValueAsDate() throws ParseException {
        String valueString = this.getFirstValue();
        if (valueString == null) {
            return null;
        }
        return XmppDateTime.parseXEP0082Date((String)valueString);
    }

    public String getVariable() {
        return this.variable;
    }

    public ValidateElement getValidateElement() {
        return this.validateElement;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setValidateElement(ValidateElement validateElement) {
        validateElement.checkConsistency(this);
        this.validateElement = validateElement;
    }

    public void setType(Type type) {
        if (type == Type.fixed) {
            throw new IllegalArgumentException("Can not set type to fixed, use FormField constructor without arguments instead.");
        }
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(CharSequence value) {
        List<CharSequence> list = this.values;
        synchronized (list) {
            this.values.add(value);
        }
    }

    public void addValue(Date date) {
        String dateString = XmppDateTime.formatXEP0082Date((Date)date);
        this.addValue(dateString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValues(List<? extends CharSequence> newValues) {
        List<CharSequence> list = this.values;
        synchronized (list) {
            this.values.addAll(newValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetValues() {
        List<CharSequence> list = this.values;
        synchronized (list) {
            this.values.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOption(Option option) {
        List<Option> list = this.options;
        synchronized (list) {
            this.options.add(option);
        }
    }

    public String getElementName() {
        return ELEMENT;
    }

    public XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder buf = new XmlStringBuilder((NamedElement)this);
        buf.optAttribute("label", this.getLabel());
        buf.optAttribute("var", this.getVariable());
        buf.optAttribute("type", (Enum)this.getType());
        buf.rightAngleBracket();
        buf.optElement("desc", this.getDescription());
        buf.condEmptyElement(this.isRequired(), "required");
        for (CharSequence value : this.getValues()) {
            buf.element("value", value);
        }
        for (Option option : this.getOptions()) {
            buf.append(option.toXML(null));
        }
        buf.optElement((Element)this.validateElement);
        buf.closeElement((NamedElement)this);
        return buf;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FormField)) {
            return false;
        }
        FormField other = (FormField)obj;
        return this.toXML(null).equals((Object)other.toXML(null));
    }

    public int hashCode() {
        return this.toXML(null).hashCode();
    }

    public static class Option
    implements NamedElement {
        public static final String ELEMENT = "option";
        private final String value;
        private String label;

        public Option(String value) {
            this.value = value;
        }

        public Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getLabel();
        }

        public String getElementName() {
            return ELEMENT;
        }

        public XmlStringBuilder toXML(String enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.optAttribute("label", this.getLabel());
            xml.rightAngleBracket();
            xml.element("value", this.getValue());
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public boolean equals(Object obj) {
            String otherLabel;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Option other = (Option)obj;
            if (!this.value.equals(other.value)) {
                return false;
            }
            String thisLabel = this.label == null ? "" : this.label;
            String string = otherLabel = other.label == null ? "" : other.label;
            return thisLabel.equals(otherLabel);
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + this.value.hashCode();
            result = 37 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }
    }

    public static enum Type {
        bool,
        fixed,
        hidden,
        jid_multi,
        jid_single,
        list_multi,
        list_single,
        text_multi,
        text_private,
        text_single;


        public String toString() {
            switch (this) {
                case bool: {
                    return "boolean";
                }
            }
            return this.name().replace('_', '-');
        }

        public static Type fromString(String string) {
            if (string == null) {
                return null;
            }
            switch (string) {
                case "boolean": {
                    return bool;
                }
            }
            string = string.replace('-', '_');
            return Type.valueOf(string);
        }
    }
}

