/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.plugin.InExporter;
import org.jivesoftware.openfire.plugin.XMLImportExportFactory;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExportPlugin
implements Plugin {
    private static final Logger Log = LoggerFactory.getLogger(ImportExportPlugin.class);
    private UserProvider provider = UserManager.getUserProvider();

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
    }

    public void destroyPlugin() {
        this.provider = null;
    }

    public boolean isUserProviderReadOnly() {
        return this.provider.isReadOnly();
    }

    public byte[] exportUsersToByteArray(boolean xep227Support) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLWriter writer = new XMLWriter((OutputStream)out, OutputFormat.createPrettyPrint());
        writer.write(this.exportUsers(xep227Support));
        return out.toByteArray();
    }

    public String exportUsersToString(boolean xep227Support) throws IOException {
        StringWriter stringWriter = new StringWriter();
        try (XMLWriter writer = null;){
            writer = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
            writer.write(this.exportUsers(xep227Support));
        }
        return StringEscapeUtils.escapeHtml4((String)stringWriter.toString());
    }

    public List<String> importUserData(FileItem file, String previousDomain, boolean xep227Support) throws DocumentException, IOException {
        InExporter exporter = XMLImportExportFactory.getExportInstance(xep227Support);
        return exporter.importUsers(file.getInputStream(), previousDomain, this.isUserProviderReadOnly());
    }

    public boolean validateImportFile(FileItem usersFile, boolean xep227Support) {
        try {
            InExporter exporter = XMLImportExportFactory.getExportInstance(xep227Support);
            return exporter.validate(usersFile.getInputStream());
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private Document exportUsers(boolean xep227Support) {
        InExporter exporter = XMLImportExportFactory.getExportInstance(xep227Support);
        return exporter.exportUsers();
    }
}

